<?php

namespace AlibabaCloud\Sas\V20181203;

use AlibabaCloud\Client\Resolver\ApiResolver;

/**
 * @method AddCheckInstanceResultWhiteList addCheckInstanceResultWhiteList(array $options = [])
 * @method AddCheckResultWhiteList addCheckResultWhiteList(array $options = [])
 * @method AddClientUserDefineRule addClientUserDefineRule(array $options = [])
 * @method AddInstallCode addInstallCode(array $options = [])
 * @method AddPrivateRegistry addPrivateRegistry(array $options = [])
 * @method AddTagWithUuid addTagWithUuid(array $options = [])
 * @method AddUninstallClientsByUuids addUninstallClientsByUuids(array $options = [])
 * @method AddVpcHoneyPot addVpcHoneyPot(array $options = [])
 * @method AdvanceSecurityEventOperations advanceSecurityEventOperations(array $options = [])
 * @method BatchOperateCommonOverallConfig batchOperateCommonOverallConfig(array $options = [])
 * @method BindAuthToMachine bindAuthToMachine(array $options = [])
 * @method CancelOnceTask cancelOnceTask(array $options = [])
 * @method ChangeCheckConfig changeCheckConfig(array $options = [])
 * @method ChangeCheckCustomConfig changeCheckCustomConfig(array $options = [])
 * @method CheckQuaraFileId checkQuaraFileId(array $options = [])
 * @method CheckSecurityEventId checkSecurityEventId(array $options = [])
 * @method CheckUserHasEcs checkUserHasEcs(array $options = [])
 * @method ConfirmVirusEvents confirmVirusEvents(array $options = [])
 * @method CreateAntiBruteForceRule createAntiBruteForceRule(array $options = [])
 * @method CreateBackupPolicy createBackupPolicy(array $options = [])
 * @method CreateContainerScanTask createContainerScanTask(array $options = [])
 * @method CreateCustomBlockRecord createCustomBlockRecord(array $options = [])
 * @method CreateCycleTask createCycleTask(array $options = [])
 * @method CreateFileDetect createFileDetect(array $options = [])
 * @method CreateFileDetectUploadUrl createFileDetectUploadUrl(array $options = [])
 * @method CreateHoneypot createHoneypot(array $options = [])
 * @method CreateHoneypotNode createHoneypotNode(array $options = [])
 * @method CreateHoneypotPreset createHoneypotPreset(array $options = [])
 * @method CreateHoneypotProbe createHoneypotProbe(array $options = [])
 * @method CreateInterceptionRule createInterceptionRule(array $options = [])
 * @method CreateInterceptionTarget createInterceptionTarget(array $options = [])
 * @method CreateJenkinsImageRegistry createJenkinsImageRegistry(array $options = [])
 * @method CreateOrUpdateAssetGroup createOrUpdateAssetGroup(array $options = [])
 * @method CreateRestoreJob createRestoreJob(array $options = [])
 * @method CreateServiceLinkedRole createServiceLinkedRole(array $options = [])
 * @method CreateSimilarSecurityEventsQueryTask createSimilarSecurityEventsQueryTask(array $options = [])
 * @method CreateSuspEventNote createSuspEventNote(array $options = [])
 * @method CreateUniBackupPolicy createUniBackupPolicy(array $options = [])
 * @method CreateUniRestorePlan createUniRestorePlan(array $options = [])
 * @method CreateVulAutoRepairConfig createVulAutoRepairConfig(array $options = [])
 * @method DeleteAntiBruteForceRule deleteAntiBruteForceRule(array $options = [])
 * @method DeleteBackupPolicy deleteBackupPolicy(array $options = [])
 * @method DeleteBackupPolicyMachine deleteBackupPolicyMachine(array $options = [])
 * @method DeleteClientUserDefineRule deleteClientUserDefineRule(array $options = [])
 * @method DeleteCustomBlockRecord deleteCustomBlockRecord(array $options = [])
 * @method DeleteCycleTask deleteCycleTask(array $options = [])
 * @method DeleteGroup deleteGroup(array $options = [])
 * @method DeleteHoneypot deleteHoneypot(array $options = [])
 * @method DeleteHoneypotNode deleteHoneypotNode(array $options = [])
 * @method DeleteHoneypotPreset deleteHoneypotPreset(array $options = [])
 * @method DeleteHoneypotProbe deleteHoneypotProbe(array $options = [])
 * @method DeleteInstallCode deleteInstallCode(array $options = [])
 * @method DeleteInterceptionRule deleteInterceptionRule(array $options = [])
 * @method DeleteInterceptionTarget deleteInterceptionTarget(array $options = [])
 * @method DeleteLoginBaseConfig deleteLoginBaseConfig(array $options = [])
 * @method DeletePrivateRegistry deletePrivateRegistry(array $options = [])
 * @method DeleteSecurityEventMarkMissList deleteSecurityEventMarkMissList(array $options = [])
 * @method DeleteStrategy deleteStrategy(array $options = [])
 * @method DeleteSuspEventNode deleteSuspEventNode(array $options = [])
 * @method DeleteTagWithUuid deleteTagWithUuid(array $options = [])
 * @method DeleteUniBackupPolicy deleteUniBackupPolicy(array $options = [])
 * @method DeleteVpcHoneyPot deleteVpcHoneyPot(array $options = [])
 * @method DeleteVulWhitelist deleteVulWhitelist(array $options = [])
 * @method DescribeAccessKeyLeakDetail describeAccessKeyLeakDetail(array $options = [])
 * @method DescribeAccesskeyLeakList describeAccesskeyLeakList(array $options = [])
 * @method DescribeAffectedAssets describeAffectedAssets(array $options = [])
 * @method DescribeAffectedMaliciousFileImages describeAffectedMaliciousFileImages(array $options = [])
 * @method DescribeAgentInstallStatus describeAgentInstallStatus(array $options = [])
 * @method DescribeAlarmEventDetail describeAlarmEventDetail(array $options = [])
 * @method DescribeAlarmEventStackInfo describeAlarmEventStackInfo(array $options = [])
 * @method DescribeAllEntity describeAllEntity(array $options = [])
 * @method DescribeAllGroups describeAllGroups(array $options = [])
 * @method DescribeAllImageBaseline describeAllImageBaseline(array $options = [])
 * @method DescribeAntiBruteForceRules describeAntiBruteForceRules(array $options = [])
 * @method DescribeAppVulScanCycle describeAppVulScanCycle(array $options = [])
 * @method DescribeAssetDetailByUuid describeAssetDetailByUuid(array $options = [])
 * @method DescribeAssetDetailByUuids describeAssetDetailByUuids(array $options = [])
 * @method DescribeAssetsSecurityEventSummary describeAssetsSecurityEventSummary(array $options = [])
 * @method DescribeAssetSummary describeAssetSummary(array $options = [])
 * @method DescribeAttackAnalysisData describeAttackAnalysisData(array $options = [])
 * @method DescribeAutoDelConfig describeAutoDelConfig(array $options = [])
 * @method DescribeBackupClients describeBackupClients(array $options = [])
 * @method DescribeBackUpExportInfo describeBackUpExportInfo(array $options = [])
 * @method DescribeBackupFiles describeBackupFiles(array $options = [])
 * @method DescribeBackupMachineStatus describeBackupMachineStatus(array $options = [])
 * @method DescribeBackupPolicies describeBackupPolicies(array $options = [])
 * @method DescribeBackupPolicy describeBackupPolicy(array $options = [])
 * @method DescribeBackupRestoreCount describeBackupRestoreCount(array $options = [])
 * @method DescribeBruteForceRecords describeBruteForceRecords(array $options = [])
 * @method DescribeBruteForceSummary describeBruteForceSummary(array $options = [])
 * @method DescribeCheckEcsWarnings describeCheckEcsWarnings(array $options = [])
 * @method DescribeCheckFixDetails describeCheckFixDetails(array $options = [])
 * @method DescribeCheckWarningDetail describeCheckWarningDetail(array $options = [])
 * @method DescribeCheckWarningMachines describeCheckWarningMachines(array $options = [])
 * @method DescribeCheckWarnings describeCheckWarnings(array $options = [])
 * @method DescribeCheckWarningSummary describeCheckWarningSummary(array $options = [])
 * @method DescribeClientConfSetup describeClientConfSetup(array $options = [])
 * @method DescribeClientConfStrategy describeClientConfStrategy(array $options = [])
 * @method DescribeCloudCenterInstances describeCloudCenterInstances(array $options = [])
 * @method DescribeCloudProductFieldStatistics describeCloudProductFieldStatistics(array $options = [])
 * @method DescribeClusterBasicInfo describeClusterBasicInfo(array $options = [])
 * @method DescribeClusterInfoList describeClusterInfoList(array $options = [])
 * @method DescribeClusterNetwork describeClusterNetwork(array $options = [])
 * @method DescribeClusterVulStatistics describeClusterVulStatistics(array $options = [])
 * @method DescribeCommonOverallConfig describeCommonOverallConfig(array $options = [])
 * @method DescribeCommonOverallConfigList describeCommonOverallConfigList(array $options = [])
 * @method DescribeCommonTargetConfig describeCommonTargetConfig(array $options = [])
 * @method DescribeCommonTargetResultList describeCommonTargetResultList(array $options = [])
 * @method DescribeConcernNecessity describeConcernNecessity(array $options = [])
 * @method DescribeContainerCriteria describeContainerCriteria(array $options = [])
 * @method DescribeContainerInstances describeContainerInstances(array $options = [])
 * @method DescribeContainerStatistics describeContainerStatistics(array $options = [])
 * @method DescribeContainerTags describeContainerTags(array $options = [])
 * @method DescribeCountNotScannedImage describeCountNotScannedImage(array $options = [])
 * @method DescribeCountScannedImage describeCountScannedImage(array $options = [])
 * @method DescribeCriteria describeCriteria(array $options = [])
 * @method DescribeCustomBlockRecords describeCustomBlockRecords(array $options = [])
 * @method DescribeCycleTaskList describeCycleTaskList(array $options = [])
 * @method DescribeDingTalk describeDingTalk(array $options = [])
 * @method DescribeDomainCount describeDomainCount(array $options = [])
 * @method DescribeDomainDetail describeDomainDetail(array $options = [])
 * @method DescribeDomainList describeDomainList(array $options = [])
 * @method DescribeEmgUserAgreement describeEmgUserAgreement(array $options = [])
 * @method DescribeEmgVulItem describeEmgVulItem(array $options = [])
 * @method DescribeEventLevelCount describeEventLevelCount(array $options = [])
 * @method DescribeEventOnStage describeEventOnStage(array $options = [])
 * @method DescribeExcludeSystemPath describeExcludeSystemPath(array $options = [])
 * @method DescribeExportInfo describeExportInfo(array $options = [])
 * @method DescribeExposedCheckWarning describeExposedCheckWarning(array $options = [])
 * @method DescribeExposedInstanceCriteria describeExposedInstanceCriteria(array $options = [])
 * @method DescribeExposedInstanceDetail describeExposedInstanceDetail(array $options = [])
 * @method DescribeExposedInstanceList describeExposedInstanceList(array $options = [])
 * @method DescribeExposedStatistics describeExposedStatistics(array $options = [])
 * @method DescribeExposedStatisticsDetail describeExposedStatisticsDetail(array $options = [])
 * @method DescribeFieldStatistics describeFieldStatistics(array $options = [])
 * @method DescribeFrontVulPatchList describeFrontVulPatchList(array $options = [])
 * @method DescribeGroupedContainerInstances describeGroupedContainerInstances(array $options = [])
 * @method DescribeGroupedInstances describeGroupedInstances(array $options = [])
 * @method DescribeGroupedMaliciousFiles describeGroupedMaliciousFiles(array $options = [])
 * @method DescribeGroupedTags describeGroupedTags(array $options = [])
 * @method DescribeGroupedVul describeGroupedVul(array $options = [])
 * @method DescribeGroupStruct describeGroupStruct(array $options = [])
 * @method DescribeHcExportInfo describeHcExportInfo(array $options = [])
 * @method DescribeHoneyPotAuth describeHoneyPotAuth(array $options = [])
 * @method DescribeHoneyPotSuspStatistics describeHoneyPotSuspStatistics(array $options = [])
 * @method DescribeImage describeImage(array $options = [])
 * @method DescribeImageBaselineCheckResult describeImageBaselineCheckResult(array $options = [])
 * @method DescribeImageBaselineCheckSummary describeImageBaselineCheckSummary(array $options = [])
 * @method DescribeImageBaselineDetail describeImageBaselineDetail(array $options = [])
 * @method DescribeImageBaselineItemList describeImageBaselineItemList(array $options = [])
 * @method DescribeImageBaselineStrategy describeImageBaselineStrategy(array $options = [])
 * @method DescribeImageCriteria describeImageCriteria(array $options = [])
 * @method DescribeImageFixTask describeImageFixTask(array $options = [])
 * @method DescribeImageGroupedVulList describeImageGroupedVulList(array $options = [])
 * @method DescribeImageInfoList describeImageInfoList(array $options = [])
 * @method DescribeImageInstances describeImageInstances(array $options = [])
 * @method DescribeImageLatestScanTask describeImageLatestScanTask(array $options = [])
 * @method DescribeImageListBySensitiveFile describeImageListBySensitiveFile(array $options = [])
 * @method DescribeImageListWithBaselineName describeImageListWithBaselineName(array $options = [])
 * @method DescribeImageRepoCriteria describeImageRepoCriteria(array $options = [])
 * @method DescribeImageRepoDetailList describeImageRepoDetailList(array $options = [])
 * @method DescribeImageRepoList describeImageRepoList(array $options = [])
 * @method DescribeImageScanAuthCount describeImageScanAuthCount(array $options = [])
 * @method DescribeImageScanAuthorization describeImageScanAuthorization(array $options = [])
 * @method DescribeImageSensitiveFileByKey describeImageSensitiveFileByKey(array $options = [])
 * @method DescribeImageSensitiveFileList describeImageSensitiveFileList(array $options = [])
 * @method DescribeImageStatistics describeImageStatistics(array $options = [])
 * @method DescribeImageVulList describeImageVulList(array $options = [])
 * @method DescribeInstallCaptcha describeInstallCaptcha(array $options = [])
 * @method DescribeInstallCode describeInstallCode(array $options = [])
 * @method DescribeInstallCodes describeInstallCodes(array $options = [])
 * @method DescribeInstanceAntiBruteForceRules describeInstanceAntiBruteForceRules(array $options = [])
 * @method DescribeInstanceRebootStatus describeInstanceRebootStatus(array $options = [])
 * @method DescribeInstanceStatistics describeInstanceStatistics(array $options = [])
 * @method DescribeIpTags describeIpTags(array $options = [])
 * @method DescribeLatestScanTask describeLatestScanTask(array $options = [])
 * @method DescribeLoginBaseConfigs describeLoginBaseConfigs(array $options = [])
 * @method DescribeLoginSwitchConfigs describeLoginSwitchConfigs(array $options = [])
 * @method DescribeLogMeta describeLogMeta(array $options = [])
 * @method DescribeLogShipperStatus describeLogShipperStatus(array $options = [])
 * @method DescribeLogstoreStorage describeLogstoreStorage(array $options = [])
 * @method DescribeMachineCanReboot describeMachineCanReboot(array $options = [])
 * @method DescribeModuleConfig describeModuleConfig(array $options = [])
 * @method DescribeNoticeConfig describeNoticeConfig(array $options = [])
 * @method DescribeNsasSuspEventType describeNsasSuspEventType(array $options = [])
 * @method DescribeOfflineMachines describeOfflineMachines(array $options = [])
 * @method DescribeOnceTask describeOnceTask(array $options = [])
 * @method DescribeOnceTaskLeafRecordPage describeOnceTaskLeafRecordPage(array $options = [])
 * @method DescribePropertyCount describePropertyCount(array $options = [])
 * @method DescribePropertyCronDetail describePropertyCronDetail(array $options = [])
 * @method DescribePropertyCronItem describePropertyCronItem(array $options = [])
 * @method DescribePropertyPortDetail describePropertyPortDetail(array $options = [])
 * @method DescribePropertyPortItem describePropertyPortItem(array $options = [])
 * @method DescribePropertyProcDetail describePropertyProcDetail(array $options = [])
 * @method DescribePropertyProcItem describePropertyProcItem(array $options = [])
 * @method DescribePropertyScaDetail describePropertyScaDetail(array $options = [])
 * @method DescribePropertyScaItem describePropertyScaItem(array $options = [])
 * @method DescribePropertyScheduleConfig describePropertyScheduleConfig(array $options = [])
 * @method DescribePropertySoftwareDetail describePropertySoftwareDetail(array $options = [])
 * @method DescribePropertySoftwareItem describePropertySoftwareItem(array $options = [])
 * @method DescribePropertyTypeScaItem describePropertyTypeScaItem(array $options = [])
 * @method DescribePropertyUsageNewest describePropertyUsageNewest(array $options = [])
 * @method DescribePropertyUserDetail describePropertyUserDetail(array $options = [])
 * @method DescribePropertyUserItem describePropertyUserItem(array $options = [])
 * @method DescribeQuaraFileDownloadInfo describeQuaraFileDownloadInfo(array $options = [])
 * @method DescribeRestoreJobs describeRestoreJobs(array $options = [])
 * @method DescribeRestorePlans describeRestorePlans(array $options = [])
 * @method DescribeRiskCheckItemResult describeRiskCheckItemResult(array $options = [])
 * @method DescribeRiskCheckResult describeRiskCheckResult(array $options = [])
 * @method DescribeRiskCheckSummary describeRiskCheckSummary(array $options = [])
 * @method DescribeRiskItemType describeRiskItemType(array $options = [])
 * @method DescribeRiskListCheckResult describeRiskListCheckResult(array $options = [])
 * @method DescribeRisks describeRisks(array $options = [])
 * @method DescribeRiskType describeRiskType(array $options = [])
 * @method DescribeSasPmAgentList describeSasPmAgentList(array $options = [])
 * @method DescribeScanTaskProgress describeScanTaskProgress(array $options = [])
 * @method DescribeScanTaskStatistics describeScanTaskStatistics(array $options = [])
 * @method DescribeSearchCondition describeSearchCondition(array $options = [])
 * @method DescribeSecureSuggestion describeSecureSuggestion(array $options = [])
 * @method DescribeSecurityCheckScheduleConfig describeSecurityCheckScheduleConfig(array $options = [])
 * @method DescribeSecurityEventOperations describeSecurityEventOperations(array $options = [])
 * @method DescribeSecurityEventOperationStatus describeSecurityEventOperationStatus(array $options = [])
 * @method DescribeSecurityStatInfo describeSecurityStatInfo(array $options = [])
 * @method DescribeServiceLinkedRoleStatus describeServiceLinkedRoleStatus(array $options = [])
 * @method DescribeSimilarEventScenarios describeSimilarEventScenarios(array $options = [])
 * @method DescribeSimilarSecurityEvents describeSimilarSecurityEvents(array $options = [])
 * @method DescribeSnapshots describeSnapshots(array $options = [])
 * @method DescribeStrategy describeStrategy(array $options = [])
 * @method DescribeStrategyDetail describeStrategyDetail(array $options = [])
 * @method DescribeStrategyExecDetail describeStrategyExecDetail(array $options = [])
 * @method DescribeStrategyTarget describeStrategyTarget(array $options = [])
 * @method DescribeSummaryInfo describeSummaryInfo(array $options = [])
 * @method DescribeSupportRegion describeSupportRegion(array $options = [])
 * @method DescribeSuspEventDetail describeSuspEventDetail(array $options = [])
 * @method DescribeSuspEventExportInfo describeSuspEventExportInfo(array $options = [])
 * @method DescribeSuspEventQuaraFiles describeSuspEventQuaraFiles(array $options = [])
 * @method DescribeSuspEvents describeSuspEvents(array $options = [])
 * @method DescribeSuspEventUserSetting describeSuspEventUserSetting(array $options = [])
 * @method DescribeSuspiciousOverallConfig describeSuspiciousOverallConfig(array $options = [])
 * @method DescribeSuspiciousUUIDConfig describeSuspiciousUUIDConfig(array $options = [])
 * @method DescribeTarget describeTarget(array $options = [])
 * @method DescribeTaskErrorLog describeTaskErrorLog(array $options = [])
 * @method DescribeTotalStatistics describeTotalStatistics(array $options = [])
 * @method DescribeTraceInfoDetail describeTraceInfoDetail(array $options = [])
 * @method DescribeTraceInfoNode describeTraceInfoNode(array $options = [])
 * @method DescribeUniBackupDatabase describeUniBackupDatabase(array $options = [])
 * @method DescribeUniBackupPolicies describeUniBackupPolicies(array $options = [])
 * @method DescribeUniBackupPolicyDetail describeUniBackupPolicyDetail(array $options = [])
 * @method DescribeUniRecoverableList describeUniRecoverableList(array $options = [])
 * @method DescribeUniSupportRegion describeUniSupportRegion(array $options = [])
 * @method DescribeUserBackupMachines describeUserBackupMachines(array $options = [])
 * @method DescribeUserBaselineAuthorization describeUserBaselineAuthorization(array $options = [])
 * @method DescribeUserLayoutAuthorization describeUserLayoutAuthorization(array $options = [])
 * @method DescribeUuidsByVulNames describeUuidsByVulNames(array $options = [])
 * @method DescribeVendorList describeVendorList(array $options = [])
 * @method DescribeVersionConfig describeVersionConfig(array $options = [])
 * @method DescribeVpcHoneyPotCriteria describeVpcHoneyPotCriteria(array $options = [])
 * @method DescribeVpcHoneyPotList describeVpcHoneyPotList(array $options = [])
 * @method DescribeVpcList describeVpcList(array $options = [])
 * @method DescribeVulCheckTaskStatusDetail describeVulCheckTaskStatusDetail(array $options = [])
 * @method DescribeVulConfig describeVulConfig(array $options = [])
 * @method DescribeVulDetails describeVulDetails(array $options = [])
 * @method DescribeVulExportInfo describeVulExportInfo(array $options = [])
 * @method DescribeVulFixStatistics describeVulFixStatistics(array $options = [])
 * @method DescribeVulList describeVulList(array $options = [])
 * @method DescribeVulListPage describeVulListPage(array $options = [])
 * @method DescribeVulNumStatistics describeVulNumStatistics(array $options = [])
 * @method DescribeVulTargetConfig describeVulTargetConfig(array $options = [])
 * @method DescribeVulTargetStatistics describeVulTargetStatistics(array $options = [])
 * @method DescribeVulWhitelist describeVulWhitelist(array $options = [])
 * @method DescribeWarningExportInfo describeWarningExportInfo(array $options = [])
 * @method DescribeWarningMachines describeWarningMachines(array $options = [])
 * @method DescribeWebLockBindList describeWebLockBindList(array $options = [])
 * @method DescribeWebLockConfigList describeWebLockConfigList(array $options = [])
 * @method DescribeWebLockExclusiveFileType describeWebLockExclusiveFileType(array $options = [])
 * @method DescribeWebLockFileChangeStatistics describeWebLockFileChangeStatistics(array $options = [])
 * @method DescribeWebLockFileEvents describeWebLockFileEvents(array $options = [])
 * @method DescribeWebLockFileTypeSummary describeWebLockFileTypeSummary(array $options = [])
 * @method DescribeWebLockInclusiveFileType describeWebLockInclusiveFileType(array $options = [])
 * @method DescribeWebLockProcessBlockStatistics describeWebLockProcessBlockStatistics(array $options = [])
 * @method DescribeWebLockProcessList describeWebLockProcessList(array $options = [])
 * @method DescribeWebLockStatus describeWebLockStatus(array $options = [])
 * @method DescribeWebLockTotalFileChangeCount describeWebLockTotalFileChangeCount(array $options = [])
 * @method DescribeWebPath describeWebPath(array $options = [])
 * @method DisableBruteForceRecord disableBruteForceRecord(array $options = [])
 * @method DisableCustomBlockRecord disableCustomBlockRecord(array $options = [])
 * @method EnableBruteForceRecord enableBruteForceRecord(array $options = [])
 * @method EnableCustomBlockRecord enableCustomBlockRecord(array $options = [])
 * @method ExecStrategy execStrategy(array $options = [])
 * @method ExportRecord exportRecord(array $options = [])
 * @method ExportSuspEvents exportSuspEvents(array $options = [])
 * @method ExportVul exportVul(array $options = [])
 * @method ExportWarning exportWarning(array $options = [])
 * @method FindContainerNetworkConnect findContainerNetworkConnect(array $options = [])
 * @method FixCheckWarnings fixCheckWarnings(array $options = [])
 * @method GenerateOnceTask generateOnceTask(array $options = [])
 * @method GetAlarmMachineCount getAlarmMachineCount(array $options = [])
 * @method GetAppNetwork getAppNetwork(array $options = [])
 * @method GetAssetsPropertyDetail getAssetsPropertyDetail(array $options = [])
 * @method GetAssetsPropertyItem getAssetsPropertyItem(array $options = [])
 * @method GetBackupStorageCount getBackupStorageCount(array $options = [])
 * @method GetCheckConfig getCheckConfig(array $options = [])
 * @method GetCheckDetail getCheckDetail(array $options = [])
 * @method GetCheckProcess getCheckProcess(array $options = [])
 * @method GetCheckRiskStatistics getCheckRiskStatistics(array $options = [])
 * @method GetCheckSummary getCheckSummary(array $options = [])
 * @method GetClientUserDefineRule getClientUserDefineRule(array $options = [])
 * @method GetCloudAssetCriteria getCloudAssetCriteria(array $options = [])
 * @method GetCloudAssetDetail getCloudAssetDetail(array $options = [])
 * @method GetCloudAssetSummary getCloudAssetSummary(array $options = [])
 * @method GetClusterCheckItemWarningStatistics getClusterCheckItemWarningStatistics(array $options = [])
 * @method GetClusterRuleSummary getClusterRuleSummary(array $options = [])
 * @method GetClusterSuspEventStatistics getClusterSuspEventStatistics(array $options = [])
 * @method GetFileDetectApiInvokeInfo getFileDetectApiInvokeInfo(array $options = [])
 * @method GetFileDetectResult getFileDetectResult(array $options = [])
 * @method GetHoneypotNode getHoneypotNode(array $options = [])
 * @method GetHoneypotPreset getHoneypotPreset(array $options = [])
 * @method GetHoneypotProbe getHoneypotProbe(array $options = [])
 * @method GetImageScanNumInPeriod getImageScanNumInPeriod(array $options = [])
 * @method GetInterceptionRuleDetail getInterceptionRuleDetail(array $options = [])
 * @method GetInterceptionSummary getInterceptionSummary(array $options = [])
 * @method GetInterceptionTargetDetail getInterceptionTargetDetail(array $options = [])
 * @method GetLastOnceTaskInfo getLastOnceTaskInfo(array $options = [])
 * @method GetModuleConfig getModuleConfig(array $options = [])
 * @method GetOnceTaskResultInfo getOnceTaskResultInfo(array $options = [])
 * @method GetPropertyScheduleConfig getPropertyScheduleConfig(array $options = [])
 * @method GetRulesCount getRulesCount(array $options = [])
 * @method GetSuspiciousStatistics getSuspiciousStatistics(array $options = [])
 * @method GetVulStatistics getVulStatistics(array $options = [])
 * @method GetVulWhitelist getVulWhitelist(array $options = [])
 * @method HandleSecurityEvents handleSecurityEvents(array $options = [])
 * @method HandleSimilarSecurityEvents handleSimilarSecurityEvents(array $options = [])
 * @method IgnoreCheckItems ignoreCheckItems(array $options = [])
 * @method IgnoreHcCheckWarnings ignoreHcCheckWarnings(array $options = [])
 * @method InstallBackupClient installBackupClient(array $options = [])
 * @method InstallCloudMonitor installCloudMonitor(array $options = [])
 * @method InstallPmAgent installPmAgent(array $options = [])
 * @method InstallUniBackupAgent installUniBackupAgent(array $options = [])
 * @method JoinWebLockProcessWhiteList joinWebLockProcessWhiteList(array $options = [])
 * @method ListAvailableHoneypot listAvailableHoneypot(array $options = [])
 * @method ListCheckInstanceResult listCheckInstanceResult(array $options = [])
 * @method ListCheckItemWarningMachine listCheckItemWarningMachine(array $options = [])
 * @method ListCheckItemWarningSummary listCheckItemWarningSummary(array $options = [])
 * @method ListCheckResult listCheckResult(array $options = [])
 * @method ListCheckStandard listCheckStandard(array $options = [])
 * @method ListClientUserDefineRules listClientUserDefineRules(array $options = [])
 * @method ListClientUserDefineRuleTypes listClientUserDefineRuleTypes(array $options = [])
 * @method ListCloudAssetInstances listCloudAssetInstances(array $options = [])
 * @method ListClusterCnnfStatusDetail listClusterCnnfStatusDetail(array $options = [])
 * @method ListClusterInterceptionConfig listClusterInterceptionConfig(array $options = [])
 * @method ListHoneypot listHoneypot(array $options = [])
 * @method ListHoneypotAlarmEvents listHoneypotAlarmEvents(array $options = [])
 * @method ListHoneypotNode listHoneypotNode(array $options = [])
 * @method ListHoneypotPreset listHoneypotPreset(array $options = [])
 * @method ListHoneypotProbe listHoneypotProbe(array $options = [])
 * @method ListImageRegistryRegion listImageRegistryRegion(array $options = [])
 * @method ListImageRisk listImageRisk(array $options = [])
 * @method ListInstanceCatalog listInstanceCatalog(array $options = [])
 * @method ListInterceptionHistory listInterceptionHistory(array $options = [])
 * @method ListInterceptionRulePage listInterceptionRulePage(array $options = [])
 * @method ListInterceptionTargetPage listInterceptionTargetPage(array $options = [])
 * @method ListPluginForUuid listPluginForUuid(array $options = [])
 * @method ListPodRisk listPodRisk(array $options = [])
 * @method ListPrivateRegistryList listPrivateRegistryList(array $options = [])
 * @method ListPrivateRegistryType listPrivateRegistryType(array $options = [])
 * @method ListRuleTargetAll listRuleTargetAll(array $options = [])
 * @method ListSystemAggregationRules listSystemAggregationRules(array $options = [])
 * @method ListSystemClientRules listSystemClientRules(array $options = [])
 * @method ListSystemClientRuleTypes listSystemClientRuleTypes(array $options = [])
 * @method ListSystemRuleAggregationTypes listSystemRuleAggregationTypes(array $options = [])
 * @method ListUninstallAegisMachines listUninstallAegisMachines(array $options = [])
 * @method ListUuidsByWebPath listUuidsByWebPath(array $options = [])
 * @method ListVulAutoRepairConfig listVulAutoRepairConfig(array $options = [])
 * @method ModifyAccessKeyLeakDeal modifyAccessKeyLeakDeal(array $options = [])
 * @method ModifyAntiBruteForceRule modifyAntiBruteForceRule(array $options = [])
 * @method ModifyAppVulScanCycle modifyAppVulScanCycle(array $options = [])
 * @method ModifyAssetGroup modifyAssetGroup(array $options = [])
 * @method ModifyAssetImportant modifyAssetImportant(array $options = [])
 * @method ModifyAutoDelConfig modifyAutoDelConfig(array $options = [])
 * @method ModifyBackupPolicy modifyBackupPolicy(array $options = [])
 * @method ModifyBackupPolicyStatus modifyBackupPolicyStatus(array $options = [])
 * @method ModifyClearLogstoreStorage modifyClearLogstoreStorage(array $options = [])
 * @method ModifyClientConfSetup modifyClientConfSetup(array $options = [])
 * @method ModifyClientConfStrategy modifyClientConfStrategy(array $options = [])
 * @method ModifyClientUserDefineRule modifyClientUserDefineRule(array $options = [])
 * @method ModifyClusterCnnfStatusUserConfirm modifyClusterCnnfStatusUserConfirm(array $options = [])
 * @method ModifyConcernNecessity modifyConcernNecessity(array $options = [])
 * @method ModifyCreateVulWhitelist modifyCreateVulWhitelist(array $options = [])
 * @method ModifyCustomBlockRecord modifyCustomBlockRecord(array $options = [])
 * @method ModifyCycleTask modifyCycleTask(array $options = [])
 * @method ModifyEmgVulSubmit modifyEmgVulSubmit(array $options = [])
 * @method ModifyGroupProperty modifyGroupProperty(array $options = [])
 * @method ModifyInstanceAntiBruteForceRule modifyInstanceAntiBruteForceRule(array $options = [])
 * @method ModifyInterceptionRule modifyInterceptionRule(array $options = [])
 * @method ModifyInterceptionRuleSwitch modifyInterceptionRuleSwitch(array $options = [])
 * @method ModifyInterceptionTarget modifyInterceptionTarget(array $options = [])
 * @method ModifyLoginBaseConfig modifyLoginBaseConfig(array $options = [])
 * @method ModifyLoginSwitchConfig modifyLoginSwitchConfig(array $options = [])
 * @method ModifyLogMetaStatus modifyLogMetaStatus(array $options = [])
 * @method ModifyNoticeConfig modifyNoticeConfig(array $options = [])
 * @method ModifyOpenLogShipper modifyOpenLogShipper(array $options = [])
 * @method ModifyOperateVul modifyOperateVul(array $options = [])
 * @method ModifyPropertyScheduleConfig modifyPropertyScheduleConfig(array $options = [])
 * @method ModifyPushAllTask modifyPushAllTask(array $options = [])
 * @method ModifyRiskCheckStatus modifyRiskCheckStatus(array $options = [])
 * @method ModifyRiskSingleResultStatus modifyRiskSingleResultStatus(array $options = [])
 * @method ModifySecurityCheckScheduleConfig modifySecurityCheckScheduleConfig(array $options = [])
 * @method ModifySecurityEventMarkMissIndividually modifySecurityEventMarkMissIndividually(array $options = [])
 * @method ModifyStartVulScan modifyStartVulScan(array $options = [])
 * @method ModifyStrategy modifyStrategy(array $options = [])
 * @method ModifyStrategyTarget modifyStrategyTarget(array $options = [])
 * @method ModifyTagWithUuid modifyTagWithUuid(array $options = [])
 * @method ModifyUniBackupPolicy modifyUniBackupPolicy(array $options = [])
 * @method ModifyVpcHoneyPot modifyVpcHoneyPot(array $options = [])
 * @method ModifyVulConfig modifyVulConfig(array $options = [])
 * @method ModifyVulTarget modifyVulTarget(array $options = [])
 * @method ModifyVulTargetConfig modifyVulTargetConfig(array $options = [])
 * @method ModifyVulWhitelistTarget modifyVulWhitelistTarget(array $options = [])
 * @method ModifyWebLockCreateConfig modifyWebLockCreateConfig(array $options = [])
 * @method ModifyWebLockDeleteConfig modifyWebLockDeleteConfig(array $options = [])
 * @method ModifyWebLockProcessStatus modifyWebLockProcessStatus(array $options = [])
 * @method ModifyWebLockStart modifyWebLockStart(array $options = [])
 * @method ModifyWebLockStatus modifyWebLockStatus(array $options = [])
 * @method ModifyWebLockUnbind modifyWebLockUnbind(array $options = [])
 * @method ModifyWebLockUpdateConfig modifyWebLockUpdateConfig(array $options = [])
 * @method ModifyWebPath modifyWebPath(array $options = [])
 * @method OpenSensitiveFileScan openSensitiveFileScan(array $options = [])
 * @method OperateAgentClientInstall operateAgentClientInstall(array $options = [])
 * @method OperateCommonOverallConfig operateCommonOverallConfig(array $options = [])
 * @method OperateCommonTargetConfig operateCommonTargetConfig(array $options = [])
 * @method OperateImageBaselineWhitelist operateImageBaselineWhitelist(array $options = [])
 * @method OperateImageVul operateImageVul(array $options = [])
 * @method OperateSuspiciousOverallConfig operateSuspiciousOverallConfig(array $options = [])
 * @method OperateSuspiciousTargetConfig operateSuspiciousTargetConfig(array $options = [])
 * @method OperateVirusEvents operateVirusEvents(array $options = [])
 * @method OperateVuls operateVuls(array $options = [])
 * @method OperateWebLockFileEvents operateWebLockFileEvents(array $options = [])
 * @method OperationCancelIgnoreSuspEvent operationCancelIgnoreSuspEvent(array $options = [])
 * @method OperationSuspEvents operationSuspEvents(array $options = [])
 * @method PageImageRegistry pageImageRegistry(array $options = [])
 * @method PauseClient pauseClient(array $options = [])
 * @method PublicCreateImageScanTask publicCreateImageScanTask(array $options = [])
 * @method PublicPreCheckImageScanTask publicPreCheckImageScanTask(array $options = [])
 * @method PublicSyncAndCreateImageScanTask publicSyncAndCreateImageScanTask(array $options = [])
 * @method QueryDiscoverDatabase queryDiscoverDatabase(array $options = [])
 * @method QueryGroupedSecurityEventMarkMissList queryGroupedSecurityEventMarkMissList(array $options = [])
 * @method QueryGroupIdByGroupName queryGroupIdByGroupName(array $options = [])
 * @method QueryJenkinsImageRegistryPersistenceDay queryJenkinsImageRegistryPersistenceDay(array $options = [])
 * @method QueryPreCheckDatabase queryPreCheckDatabase(array $options = [])
 * @method RebootMachine rebootMachine(array $options = [])
 * @method RefreshAssets refreshAssets(array $options = [])
 * @method RefreshContainerAssets refreshContainerAssets(array $options = [])
 * @method RemoveCheckInstanceResultWhiteList removeCheckInstanceResultWhiteList(array $options = [])
 * @method RemoveCheckResultWhiteList removeCheckResultWhiteList(array $options = [])
 * @method RollbackSuspEventQuaraFile rollbackSuspEventQuaraFile(array $options = [])
 * @method SasInstallCode sasInstallCode(array $options = [])
 * @method SaveImageBaselineStrategy saveImageBaselineStrategy(array $options = [])
 * @method SaveSuspEventUserSetting saveSuspEventUserSetting(array $options = [])
 * @method SetClusterInterceptionConfig setClusterInterceptionConfig(array $options = [])
 * @method SetRegistryScanDayNum setRegistryScanDayNum(array $options = [])
 * @method StartBaselineSecurityCheck startBaselineSecurityCheck(array $options = [])
 * @method StartDiscoverDatabaseTask startDiscoverDatabaseTask(array $options = [])
 * @method StartPreCheckDatabase startPreCheckDatabase(array $options = [])
 * @method StartVirusScanTask startVirusScanTask(array $options = [])
 * @method SubmitCheck submitCheck(array $options = [])
 * @method UnbindAegis unbindAegis(array $options = [])
 * @method UninstallBackupClient uninstallBackupClient(array $options = [])
 * @method UninstallUniBackupAgent uninstallUniBackupAgent(array $options = [])
 * @method UpdateHoneypot updateHoneypot(array $options = [])
 * @method UpdateHoneypotNode updateHoneypotNode(array $options = [])
 * @method UpdateHoneypotPreset updateHoneypotPreset(array $options = [])
 * @method UpdateHoneypotProbe updateHoneypotProbe(array $options = [])
 * @method UpdateJenkinsImageRegistryName updateJenkinsImageRegistryName(array $options = [])
 * @method UpdateJenkinsImageRegistryPersistenceDay updateJenkinsImageRegistryPersistenceDay(array $options = [])
 * @method UpgradeBackupPolicyVersion upgradeBackupPolicyVersion(array $options = [])
 * @method ValidateHcWarnings validateHcWarnings(array $options = [])
 * @method VerifyCheckInstanceResult verifyCheckInstanceResult(array $options = [])
 * @method VerifyCheckResult verifyCheckResult(array $options = [])
 */
class SasApiResolver extends ApiResolver
{
}

class Rpc extends \AlibabaCloud\Client\Resolver\Rpc
{
    /** @var string */
    public $product = 'Sas';

    /** @var string */
    public $version = '2018-12-03';

    /** @var string */
    public $method = 'POST';
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getCheckGroupId()
 * @method $this withCheckGroupId($value)
 * @method array getInstanceIds()
 * @method string getCheckId()
 * @method $this withCheckId($value)
 */
class AddCheckInstanceResultWhiteList extends Rpc
{

    /**
     * @param array $instanceIds
     *
     * @return $this
     */
	public function withInstanceIds(array $instanceIds)
	{
	    $this->data['InstanceIds'] = $instanceIds;
		foreach ($instanceIds as $i => $iValue) {
			$this->options['query']['InstanceIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method array getCheckIds()
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class AddCheckResultWhiteList extends Rpc
{

    /**
     * @param array $checkIds
     *
     * @return $this
     */
	public function withCheckIds(array $checkIds)
	{
	    $this->data['CheckIds'] = $checkIds;
		foreach ($checkIds as $i => $iValue) {
			$this->options['query']['CheckIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getActionType()
 * @method $this withActionType($value)
 * @method string getNewFilePath()
 * @method $this withNewFilePath($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getPlatform()
 * @method $this withPlatform($value)
 * @method string getRegistryKey()
 * @method $this withRegistryKey($value)
 * @method string getCmdline()
 * @method $this withCmdline($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFilePath()
 * @method $this withFilePath($value)
 * @method string getMd5List()
 * @method $this withMd5List($value)
 * @method string getParentProcPath()
 * @method $this withParentProcPath($value)
 * @method string getProcPath()
 * @method $this withProcPath($value)
 * @method string getParentCmdline()
 * @method $this withParentCmdline($value)
 * @method string getIP()
 * @method $this withIP($value)
 * @method string getRegistryContent()
 * @method $this withRegistryContent($value)
 * @method string getPortStr()
 * @method $this withPortStr($value)
 * @method string getPort()
 * @method $this withPort($value)
 * @method string getName()
 * @method $this withName($value)
 */
class AddClientUserDefineRule extends Rpc
{
}

/**
 * @method string getExpiredDate()
 * @method $this withExpiredDate($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getOs()
 * @method $this withOs($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getProxyCluster()
 * @method $this withProxyCluster($value)
 * @method string getOnlyImage()
 * @method $this withOnlyImage($value)
 * @method string getVendorName()
 * @method $this withVendorName($value)
 */
class AddInstallCode extends Rpc
{
}

/**
 * @method string getExtraParam()
 * @method $this withExtraParam($value)
 * @method string getRegistryVersion()
 * @method $this withRegistryVersion($value)
 * @method string getRegistryHostIp()
 * @method $this withRegistryHostIp($value)
 * @method string getPassword()
 * @method $this withPassword($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getRegistryRegionId()
 * @method $this withRegistryRegionId($value)
 * @method string getTransPerHour()
 * @method $this withTransPerHour($value)
 * @method string getRegistryType()
 * @method $this withRegistryType($value)
 * @method string getDomainName()
 * @method $this withDomainName($value)
 * @method string getNetType()
 * @method $this withNetType($value)
 * @method string getVpcId()
 * @method $this withVpcId($value)
 * @method string getProtocolType()
 * @method $this withProtocolType($value)
 * @method string getUserName()
 * @method $this withUserName($value)
 */
class AddPrivateRegistry extends Rpc
{
}

/**
 * @method string getTagName()
 * @method $this withTagName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuidList()
 * @method $this withUuidList($value)
 */
class AddTagWithUuid extends Rpc
{
}

/**
 * @method string getCallMethod()
 * @method $this withCallMethod($value)
 * @method string getFeedback()
 * @method $this withFeedback($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getRegion()
 * @method $this withRegion($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class AddUninstallClientsByUuids extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getVpcId()
 * @method $this withVpcId($value)
 */
class AddVpcHoneyPot extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getEventName()
 * @method $this withEventName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getEventType()
 * @method $this withEventType($value)
 * @method string getRuleId()
 * @method $this withRuleId($value)
 */
class AdvanceSecurityEventOperations extends Rpc
{
}

/**
 * @method array getTypeList()
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getConfig()
 * @method $this withConfig($value)
 */
class BatchOperateCommonOverallConfig extends Rpc
{

    /**
     * @param array $typeList
     *
     * @return $this
     */
	public function withTypeList(array $typeList)
	{
	    $this->data['TypeList'] = $typeList;
		foreach ($typeList as $i => $iValue) {
			$this->options['query']['TypeList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getCriteria()
 * @method $this withCriteria($value)
 * @method string getBindAll()
 * @method $this withBindAll($value)
 * @method array getBind()
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getAuthVersion()
 * @method $this withAuthVersion($value)
 * @method string getLogicalExp()
 * @method $this withLogicalExp($value)
 * @method string getAutoBind()
 * @method $this withAutoBind($value)
 * @method array getUnBind()
 */
class BindAuthToMachine extends Rpc
{

    /**
     * @param array $bind
     *
     * @return $this
     */
	public function withBind(array $bind)
	{
	    $this->data['Bind'] = $bind;
		foreach ($bind as $i => $iValue) {
			$this->options['query']['Bind.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $unBind
     *
     * @return $this
     */
	public function withUnBind(array $unBind)
	{
	    $this->data['UnBind'] = $unBind;
		foreach ($unBind as $i => $iValue) {
			$this->options['query']['UnBind.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getTaskId()
 * @method $this withTaskId($value)
 */
class CancelOnceTask extends Rpc
{
}

/**
 * @method array getStandardIds()
 * @method string getEndTime()
 * @method $this withEndTime($value)
 * @method array getCycleDays()
 * @method string getStartTime()
 * @method $this withStartTime($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class ChangeCheckConfig extends Rpc
{

    /**
     * @param array $standardIds
     *
     * @return $this
     */
	public function withStandardIds(array $standardIds)
	{
	    $this->data['StandardIds'] = $standardIds;
		foreach ($standardIds as $i => $iValue) {
			$this->options['query']['StandardIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $cycleDays
     *
     * @return $this
     */
	public function withCycleDays(array $cycleDays)
	{
	    $this->data['CycleDays'] = $cycleDays;
		foreach ($cycleDays as $i => $iValue) {
			$this->options['query']['CycleDays.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method array getCustomConfigs()
 * @method string getCheckId()
 * @method $this withCheckId($value)
 */
class ChangeCheckCustomConfig extends Rpc
{

    /**
     * @param array $customConfigs
     *
     * @return $this
     */
	public function withCustomConfigs(array $customConfigs)
	{
	    $this->data['CustomConfigs'] = $customConfigs;
		foreach ($customConfigs as $depth1 => $depth1Value) {
			if(isset($depth1Value['Name'])){
				$this->options['query']['CustomConfigs.' . ($depth1 + 1) . '.Name'] = $depth1Value['Name'];
			}
			if(isset($depth1Value['Value'])){
				$this->options['query']['CustomConfigs.' . ($depth1 + 1) . '.Value'] = $depth1Value['Value'];
			}
			if(isset($depth1Value['Operation'])){
				$this->options['query']['CustomConfigs.' . ($depth1 + 1) . '.Operation'] = $depth1Value['Operation'];
			}
		}

		return $this;
    }
}

/**
 * @method array getQuaraFileIds()
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class CheckQuaraFileId extends Rpc
{

    /**
     * @param array $quaraFileIds
     *
     * @return $this
     */
	public function withQuaraFileIds(array $quaraFileIds)
	{
	    $this->data['QuaraFileIds'] = $quaraFileIds;
		foreach ($quaraFileIds as $i => $iValue) {
			$this->options['query']['QuaraFileIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method array getSecurityEventIds()
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class CheckSecurityEventId extends Rpc
{

    /**
     * @param array $securityEventIds
     *
     * @return $this
     */
	public function withSecurityEventIds(array $securityEventIds)
	{
	    $this->data['SecurityEventIds'] = $securityEventIds;
		foreach ($securityEventIds as $i => $iValue) {
			$this->options['query']['SecurityEventIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 */
class CheckUserHasEcs extends Rpc
{
}

/**
 * @method string getOperationRange()
 * @method $this withOperationRange($value)
 * @method string getOperationAll()
 * @method $this withOperationAll($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getOperationCode()
 * @method $this withOperationCode($value)
 */
class ConfirmVirusEvents extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getForbiddenTime()
 * @method $this withForbiddenTime($value)
 * @method string getFailCount()
 * @method $this withFailCount($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getEnableSmartRule()
 * @method $this withEnableSmartRule($value)
 * @method array getUuidList()
 * @method string getName()
 * @method $this withName($value)
 * @method string getSpan()
 * @method $this withSpan($value)
 * @method string getDefaultRule()
 * @method $this withDefaultRule($value)
 */
class CreateAntiBruteForceRule extends Rpc
{

    /**
     * @param array $uuidList
     *
     * @return $this
     */
	public function withUuidList(array $uuidList)
	{
	    $this->data['UuidList'] = $uuidList;
		foreach ($uuidList as $i => $iValue) {
			$this->options['query']['UuidList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getServerType()
 * @method $this withServerType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method array getUuidList()
 * @method string getPolicy()
 * @method $this withPolicy($value)
 * @method string getPolicyVersion()
 * @method $this withPolicyVersion($value)
 * @method string getPolicyRegionId()
 * @method $this withPolicyRegionId($value)
 * @method string getName()
 * @method $this withName($value)
 */
class CreateBackupPolicy extends Rpc
{

    /**
     * @param array $uuidList
     *
     * @return $this
     */
	public function withUuidList(array $uuidList)
	{
	    $this->data['UuidList'] = $uuidList;
		foreach ($uuidList as $i => $iValue) {
			$this->options['query']['UuidList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getContainerIds()
 * @method $this withContainerIds($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class CreateContainerScanTask extends Rpc
{
}

/**
 * @method string getExpireTime()
 * @method $this withExpireTime($value)
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getBound()
 * @method $this withBound($value)
 * @method string getBlockIp()
 * @method $this withBlockIp($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class CreateCustomBlockRecord extends Rpc
{
}

/**
 * @method string getFirstDateStr()
 * @method $this withFirstDateStr($value)
 * @method string getTaskName()
 * @method $this withTaskName($value)
 * @method string getSource()
 * @method $this withSource($value)
 * @method string getTargetStartTime()
 * @method $this withTargetStartTime($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getIntervalPeriod()
 * @method $this withIntervalPeriod($value)
 * @method string getParam()
 * @method $this withParam($value)
 * @method string getEnable()
 * @method $this withEnable($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 * @method string getTaskType()
 * @method $this withTaskType($value)
 * @method string getTargetEndTime()
 * @method $this withTargetEndTime($value)
 * @method string getPeriodUnit()
 * @method $this withPeriodUnit($value)
 */
class CreateCycleTask extends Rpc
{
}

/**
 * @method string getHashKey()
 * @method $this withHashKey($value)
 * @method string getOssKey()
 * @method $this withOssKey($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class CreateFileDetect extends Rpc
{
}

/**
 * @method array getHashKeyList()
 * @method string getType()
 * @method $this withType($value)
 * @method array getHashKeyContextList()
 */
class CreateFileDetectUploadUrl extends Rpc
{

    /**
     * @param array $hashKeyList
     *
     * @return $this
     */
	public function withHashKeyList(array $hashKeyList)
	{
	    $this->data['HashKeyList'] = $hashKeyList;
		foreach ($hashKeyList as $i => $iValue) {
			$this->options['query']['HashKeyList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $hashKeyContextList
     *
     * @return $this
     */
	public function withHashKeyContextList(array $hashKeyContextList)
	{
	    $this->data['HashKeyContextList'] = $hashKeyContextList;
		foreach ($hashKeyContextList as $depth1 => $depth1Value) {
			if(isset($depth1Value['HashKey'])){
				$this->options['query']['HashKeyContextList.' . ($depth1 + 1) . '.HashKey'] = $depth1Value['HashKey'];
			}
			if(isset($depth1Value['FileSize'])){
				$this->options['query']['HashKeyContextList.' . ($depth1 + 1) . '.FileSize'] = $depth1Value['FileSize'];
			}
		}

		return $this;
    }
}

/**
 * @method string getHoneypotName()
 * @method $this withHoneypotName($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getNodeId()
 * @method $this withNodeId($value)
 * @method string getHoneypotImageId()
 * @method $this withHoneypotImageId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getMeta()
 * @method $this withMeta($value)
 * @method string getHoneypotImageName()
 * @method $this withHoneypotImageName($value)
 */
class CreateHoneypot extends Rpc
{
}

/**
 * @method string getAvailableProbeNum()
 * @method $this withAvailableProbeNum($value)
 * @method string getAllowHoneypotAccessInternet()
 * @method $this withAllowHoneypotAccessInternet($value)
 * @method string getNodeName()
 * @method $this withNodeName($value)
 * @method array getSecurityGroupProbeIpList()
 * @method string getNodeVersion()
 * @method $this withNodeVersion($value)
 */
class CreateHoneypotNode extends Rpc
{

    /**
     * @param array $securityGroupProbeIpList
     *
     * @return $this
     */
	public function withSecurityGroupProbeIpList(array $securityGroupProbeIpList)
	{
	    $this->data['SecurityGroupProbeIpList'] = $securityGroupProbeIpList;
		foreach ($securityGroupProbeIpList as $i => $iValue) {
			$this->options['query']['SecurityGroupProbeIpList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getNodeId()
 * @method $this withNodeId($value)
 * @method string getPresetName()
 * @method $this withPresetName($value)
 * @method string getMeta()
 * @method $this withMeta($value)
 * @method string getHoneypotImageName()
 * @method $this withHoneypotImageName($value)
 */
class CreateHoneypotPreset extends Rpc
{
}

/**
 * @method string getControlNodeId()
 * @method $this withControlNodeId($value)
 * @method string getProxyIp()
 * @method $this withProxyIp($value)
 * @method string getPing()
 * @method $this withPing($value)
 * @method string getProbeId()
 * @method $this withProbeId($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getProbeVersion()
 * @method $this withProbeVersion($value)
 * @method array getServiceIpList()
 * @method array getHoneypotBindList()
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getArp()
 * @method $this withArp($value)
 * @method string getProbeType()
 * @method $this withProbeType($value)
 * @method string getProbeStatus()
 * @method $this withProbeStatus($value)
 * @method string getBusinessGroupId()
 * @method $this withBusinessGroupId($value)
 * @method string getDisplayName()
 * @method $this withDisplayName($value)
 * @method string getVpcId()
 * @method $this withVpcId($value)
 */
class CreateHoneypotProbe extends Rpc
{

    /**
     * @param array $serviceIpList
     *
     * @return $this
     */
	public function withServiceIpList(array $serviceIpList)
	{
	    $this->data['ServiceIpList'] = $serviceIpList;
		foreach ($serviceIpList as $i => $iValue) {
			$this->options['query']['ServiceIpList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $honeypotBindList
     *
     * @return $this
     */
	public function withHoneypotBindList(array $honeypotBindList)
	{
	    $this->data['HoneypotBindList'] = $honeypotBindList;
		foreach ($honeypotBindList as $depth1 => $depth1Value) {
			foreach ($depth1Value['BindPortList'] as $depth2 => $depth2Value) {
				if(isset($depth2Value['StartPort'])){
					$this->options['query']['HoneypotBindList.' . ($depth1 + 1) . '.BindPortList.' . ($depth2 + 1) . '.StartPort'] = $depth2Value['StartPort'];
				}
				if(isset($depth2Value['BindPort'])){
					$this->options['query']['HoneypotBindList.' . ($depth1 + 1) . '.BindPortList.' . ($depth2 + 1) . '.BindPort'] = $depth2Value['BindPort'];
				}
				if(isset($depth2Value['Fixed'])){
					$this->options['query']['HoneypotBindList.' . ($depth1 + 1) . '.BindPortList.' . ($depth2 + 1) . '.Fixed'] = $depth2Value['Fixed'];
				}
				if(isset($depth2Value['EndPort'])){
					$this->options['query']['HoneypotBindList.' . ($depth1 + 1) . '.BindPortList.' . ($depth2 + 1) . '.EndPort'] = $depth2Value['EndPort'];
				}
				if(isset($depth2Value['TargetPort'])){
					$this->options['query']['HoneypotBindList.' . ($depth1 + 1) . '.BindPortList.' . ($depth2 + 1) . '.TargetPort'] = $depth2Value['TargetPort'];
				}
			}
			if(isset($depth1Value['HoneypotId'])){
				$this->options['query']['HoneypotBindList.' . ($depth1 + 1) . '.HoneypotId'] = $depth1Value['HoneypotId'];
			}
		}

		return $this;
    }
}

/**
 * @method string getClusterName()
 * @method $this withClusterName($value)
 * @method string getRuleName()
 * @method $this withRuleName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getDstTargetList()
 * @method $this withDstTargetList($value)
 * @method string getOrderIndex()
 * @method $this withOrderIndex($value)
 * @method string getRuleType()
 * @method $this withRuleType($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getInterceptType()
 * @method $this withInterceptType($value)
 * @method string getRuleSwitch()
 * @method $this withRuleSwitch($value)
 * @method string getSrcTarget()
 * @method $this withSrcTarget($value)
 */
class CreateInterceptionRule extends Rpc
{
}

/**
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method string getClusterName()
 * @method $this withClusterName($value)
 * @method array getImageList()
 * @method array getTagList()
 * @method string getTargetName()
 * @method $this withTargetName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getAppName()
 * @method $this withAppName($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getNamespace()
 * @method $this withNamespace($value)
 */
class CreateInterceptionTarget extends Rpc
{

    /**
     * @param array $imageList
     *
     * @return $this
     */
	public function withImageList(array $imageList)
	{
	    $this->data['ImageList'] = $imageList;
		foreach ($imageList as $i => $iValue) {
			$this->options['query']['ImageList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $tagList
     *
     * @return $this
     */
	public function withTagList(array $tagList)
	{
	    $this->data['TagList'] = $tagList;
		foreach ($tagList as $i => $iValue) {
			$this->options['query']['TagList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getExtraParam()
 * @method string getRegistryVersion()
 * @method string getRegistryHostIp()
 * @method string getPassword()
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getRegistryName()
 * @method string getTransPerHour()
 * @method string getRegistryType()
 * @method string getDomainName()
 * @method string getWhiteList()
 * @method string getNetType()
 * @method string getVpcId()
 * @method string getPersistenceDay()
 * @method string getProtocolType()
 * @method string getUserName()
 */
class CreateJenkinsImageRegistry extends Rpc
{

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withExtraParam($value)
    {
        $this->data['ExtraParam'] = $value;
        $this->options['form_params']['ExtraParam'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withRegistryVersion($value)
    {
        $this->data['RegistryVersion'] = $value;
        $this->options['form_params']['RegistryVersion'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withRegistryHostIp($value)
    {
        $this->data['RegistryHostIp'] = $value;
        $this->options['form_params']['RegistryHostIp'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withPassword($value)
    {
        $this->data['Password'] = $value;
        $this->options['form_params']['Password'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withRegistryName($value)
    {
        $this->data['RegistryName'] = $value;
        $this->options['form_params']['RegistryName'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withTransPerHour($value)
    {
        $this->data['TransPerHour'] = $value;
        $this->options['form_params']['TransPerHour'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withRegistryType($value)
    {
        $this->data['RegistryType'] = $value;
        $this->options['form_params']['RegistryType'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withDomainName($value)
    {
        $this->data['DomainName'] = $value;
        $this->options['form_params']['DomainName'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withWhiteList($value)
    {
        $this->data['WhiteList'] = $value;
        $this->options['form_params']['WhiteList'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withNetType($value)
    {
        $this->data['NetType'] = $value;
        $this->options['form_params']['NetType'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withVpcId($value)
    {
        $this->data['VpcId'] = $value;
        $this->options['form_params']['VpcId'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withPersistenceDay($value)
    {
        $this->data['PersistenceDay'] = $value;
        $this->options['form_params']['PersistenceDay'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withProtocolType($value)
    {
        $this->data['ProtocolType'] = $value;
        $this->options['form_params']['ProtocolType'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withUserName($value)
    {
        $this->data['UserName'] = $value;
        $this->options['form_params']['UserName'] = $value;

        return $this;
    }
}

/**
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getGroupName()
 * @method $this withGroupName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class CreateOrUpdateAssetGroup extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSnapshotId()
 * @method $this withSnapshotId($value)
 * @method string getVaultId()
 * @method $this withVaultId($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSnapshotHash()
 * @method $this withSnapshotHash($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getSourceType()
 * @method $this withSourceType($value)
 * @method string getSnapshotVersion()
 * @method $this withSnapshotVersion($value)
 * @method string getIncludes()
 * @method $this withIncludes($value)
 * @method string getTarget()
 * @method $this withTarget($value)
 */
class CreateRestoreJob extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getServiceLinkedRole()
 * @method $this withServiceLinkedRole($value)
 */
class CreateServiceLinkedRole extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getSecurityEventId()
 * @method $this withSecurityEventId($value)
 * @method string getSimilarEventScenarioCode()
 * @method $this withSimilarEventScenarioCode($value)
 */
class CreateSimilarSecurityEventsQueryTask extends Rpc
{
}

/**
 * @method string getEventId()
 * @method $this withEventId($value)
 * @method string getNote()
 * @method $this withNote($value)
 */
class CreateSuspEventNote extends Rpc
{
}

/**
 * @method string getDatabaseType()
 * @method $this withDatabaseType($value)
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSpeedLimiter()
 * @method $this withSpeedLimiter($value)
 * @method string getIncPlan()
 * @method $this withIncPlan($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getAccountName()
 * @method $this withAccountName($value)
 * @method string getDatabaseAddByUser()
 * @method $this withDatabaseAddByUser($value)
 * @method string getFullPlan()
 * @method $this withFullPlan($value)
 * @method string getRetention()
 * @method $this withRetention($value)
 * @method string getAccountPassword()
 * @method $this withAccountPassword($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 * @method string getPolicyName()
 * @method $this withPolicyName($value)
 * @method string getUniRegionId()
 * @method $this withUniRegionId($value)
 */
class CreateUniBackupPolicy extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getInstanceUuid()
 * @method $this withInstanceUuid($value)
 * @method string getRestoreInfo()
 * @method $this withRestoreInfo($value)
 * @method string getDatabase()
 * @method $this withDatabase($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPolicyId()
 * @method $this withPolicyId($value)
 * @method string getResetScn()
 * @method $this withResetScn($value)
 * @method string getResetTime()
 * @method $this withResetTime($value)
 * @method string getTimePoint()
 * @method $this withTimePoint($value)
 */
class CreateUniRestorePlan extends Rpc
{
}

/**
 * @method string getReason()
 * @method $this withReason($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method array getVulAutoRepairConfigList()
 */
class CreateVulAutoRepairConfig extends Rpc
{

    /**
     * @param array $vulAutoRepairConfigList
     *
     * @return $this
     */
	public function withVulAutoRepairConfigList(array $vulAutoRepairConfigList)
	{
	    $this->data['VulAutoRepairConfigList'] = $vulAutoRepairConfigList;
		foreach ($vulAutoRepairConfigList as $depth1 => $depth1Value) {
			if(isset($depth1Value['AliasName'])){
				$this->options['query']['VulAutoRepairConfigList.' . ($depth1 + 1) . '.AliasName'] = $depth1Value['AliasName'];
			}
			if(isset($depth1Value['Name'])){
				$this->options['query']['VulAutoRepairConfigList.' . ($depth1 + 1) . '.Name'] = $depth1Value['Name'];
			}
		}

		return $this;
    }
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method array getIds()
 */
class DeleteAntiBruteForceRule extends Rpc
{

    /**
     * @param array $ids
     *
     * @return $this
     */
	public function withIds(array $ids)
	{
	    $this->data['Ids'] = $ids;
		foreach ($ids as $i => $iValue) {
			$this->options['query']['Ids.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getPolicyVersion()
 * @method $this withPolicyVersion($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getId()
 * @method $this withId($value)
 */
class DeleteBackupPolicy extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getPolicyVersion()
 * @method $this withPolicyVersion($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPolicyId()
 * @method $this withPolicyId($value)
 * @method array getUuidList()
 */
class DeleteBackupPolicyMachine extends Rpc
{

    /**
     * @param array $uuidList
     *
     * @return $this
     */
	public function withUuidList(array $uuidList)
	{
	    $this->data['UuidList'] = $uuidList;
		foreach ($uuidList as $i => $iValue) {
			$this->options['query']['UuidList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method array getIdList()
 */
class DeleteClientUserDefineRule extends Rpc
{

    /**
     * @param array $idList
     *
     * @return $this
     */
	public function withIdList(array $idList)
	{
	    $this->data['IdList'] = $idList;
		foreach ($idList as $i => $iValue) {
			$this->options['query']['IdList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getId()
 * @method $this withId($value)
 */
class DeleteCustomBlockRecord extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getConfigId()
 * @method $this withConfigId($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DeleteCycleTask extends Rpc
{
}

/**
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DeleteGroup extends Rpc
{
}

/**
 * @method string getHoneypotId()
 * @method $this withHoneypotId($value)
 */
class DeleteHoneypot extends Rpc
{
}

/**
 * @method string getNodeId()
 * @method $this withNodeId($value)
 */
class DeleteHoneypotNode extends Rpc
{
}

/**
 * @method string getHoneypotPresetId()
 * @method $this withHoneypotPresetId($value)
 */
class DeleteHoneypotPreset extends Rpc
{
}

/**
 * @method string getProbeId()
 * @method $this withProbeId($value)
 */
class DeleteHoneypotProbe extends Rpc
{
}

/**
 * @method string getCaptchaCode()
 * @method $this withCaptchaCode($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DeleteInstallCode extends Rpc
{
}

/**
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method array getRuleIds()
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DeleteInterceptionRule extends Rpc
{

    /**
     * @param array $ruleIds
     *
     * @return $this
     */
	public function withRuleIds(array $ruleIds)
	{
	    $this->data['RuleIds'] = $ruleIds;
		foreach ($ruleIds as $i => $iValue) {
			$this->options['query']['RuleIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getTargetIds()
 * @method $this withTargetIds($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DeleteInterceptionTarget extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getTarget()
 * @method $this withTarget($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getConfig()
 * @method $this withConfig($value)
 */
class DeleteLoginBaseConfig extends Rpc
{
}

/**
 * @method string getRegistryId()
 * @method $this withRegistryId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DeletePrivateRegistry extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method array getIds()
 */
class DeleteSecurityEventMarkMissList extends Rpc
{

    /**
     * @param array $ids
     *
     * @return $this
     */
	public function withIds(array $ids)
	{
	    $this->data['Ids'] = $ids;
		foreach ($ids as $i => $iValue) {
			$this->options['query']['Ids.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getId()
 * @method $this withId($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DeleteStrategy extends Rpc
{
}

/**
 * @method string getNoteId()
 * @method $this withNoteId($value)
 */
class DeleteSuspEventNode extends Rpc
{
}

/**
 * @method string getTagName()
 * @method $this withTagName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuidList()
 * @method $this withUuidList($value)
 */
class DeleteTagWithUuid extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getPolicyIds()
 * @method $this withPolicyIds($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPolicyId()
 * @method $this withPolicyId($value)
 */
class DeleteUniBackupPolicy extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getVpcId()
 * @method $this withVpcId($value)
 */
class DeleteVpcHoneyPot extends Rpc
{
}

/**
 * @method string getWhitelist()
 * @method $this withWhitelist($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getId()
 * @method $this withId($value)
 */
class DeleteVulWhitelist extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getId()
 * @method $this withId($value)
 */
class DescribeAccessKeyLeakDetail extends Rpc
{
}

/**
 * @method string getQuery()
 * @method $this withQuery($value)
 * @method string getStartTs()
 * @method $this withStartTs($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class DescribeAccesskeyLeakList extends Rpc
{
}

/**
 * @method string getCurrent()
 * @method $this withCurrent($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLevels()
 * @method $this withLevels($value)
 */
class DescribeAffectedAssets extends Rpc
{
}

/**
 * @method string getRepoId()
 * @method $this withRepoId($value)
 * @method string getPod()
 * @method $this withPod($value)
 * @method string getClusterName()
 * @method $this withClusterName($value)
 * @method string getRepoNamespace()
 * @method $this withRepoNamespace($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getImageDigest()
 * @method $this withImageDigest($value)
 * @method array getScanRange()
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getImageTag()
 * @method $this withImageTag($value)
 * @method string getImage()
 * @method $this withImage($value)
 * @method string getMaliciousMd5()
 * @method $this withMaliciousMd5($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getRepoName()
 * @method $this withRepoName($value)
 * @method string getNamespace()
 * @method $this withNamespace($value)
 * @method string getRepoInstanceId()
 * @method $this withRepoInstanceId($value)
 * @method string getImageLayer()
 * @method $this withImageLayer($value)
 * @method string getContainerId()
 * @method $this withContainerId($value)
 * @method string getLevels()
 * @method $this withLevels($value)
 * @method string getRepoRegionId()
 * @method $this withRepoRegionId($value)
 * @method array getUuids()
 */
class DescribeAffectedMaliciousFileImages extends Rpc
{

    /**
     * @param array $scanRange
     *
     * @return $this
     */
	public function withScanRange(array $scanRange)
	{
	    $this->data['ScanRange'] = $scanRange;
		foreach ($scanRange as $i => $iValue) {
			$this->options['query']['ScanRange.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $uuids
     *
     * @return $this
     */
	public function withUuids(array $uuids)
	{
	    $this->data['Uuids'] = $uuids;
		foreach ($uuids as $i => $iValue) {
			$this->options['query']['Uuids.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class DescribeAgentInstallStatus extends Rpc
{
}

/**
 * @method string getAlarmUniqueInfo()
 * @method $this withAlarmUniqueInfo($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeAlarmEventDetail extends Rpc
{
}

/**
 * @method string getUniqueInfo()
 * @method $this withUniqueInfo($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getEventName()
 * @method $this withEventName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeAlarmEventStackInfo extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeAllEntity extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DescribeAllGroups extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeAllImageBaseline extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getId()
 * @method $this withId($value)
 */
class DescribeAntiBruteForceRules extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DescribeAppVulScanCycle extends Rpc
{
}

/**
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeAssetDetailByUuid extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class DescribeAssetDetailByUuids extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getContainerFieldName()
 * @method $this withContainerFieldName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getContainerFieldValue()
 * @method $this withContainerFieldValue($value)
 */
class DescribeAssetsSecurityEventSummary extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeAssetSummary extends Rpc
{
}

/**
 * @method string getData()
 * @method $this withData($value)
 * @method string getBase64()
 * @method $this withBase64($value)
 * @method string getStartTime()
 * @method $this withStartTime($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getEndTime()
 * @method $this withEndTime($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 */
class DescribeAttackAnalysisData extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DescribeAutoDelConfig extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSupportRegionId()
 * @method $this withSupportRegionId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeBackupClients extends Rpc
{
}

/**
 * @method string getExportType()
 * @method $this withExportType($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeBackUpExportInfo extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getPath()
 * @method $this withPath($value)
 * @method string getSnapshotHash()
 * @method $this withSnapshotHash($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getNextToken()
 * @method $this withNextToken($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getMaxResults()
 * @method $this withMaxResults($value)
 */
class DescribeBackupFiles extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getPolicyVersion()
 * @method $this withPolicyVersion($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPolicyId()
 * @method $this withPolicyId($value)
 */
class DescribeBackupMachineStatus extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getMachineRemark()
 * @method $this withMachineRemark($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class DescribeBackupPolicies extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getId()
 * @method $this withId($value)
 */
class DescribeBackupPolicy extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeBackupRestoreCount extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getBlockIp()
 * @method $this withBlockIp($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class DescribeBruteForceRecords extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeBruteForceSummary extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeCheckEcsWarnings extends Rpc
{
}

/**
 * @method string getCheckIds()
 * @method $this withCheckIds($value)
 * @method string getRiskId()
 * @method $this withRiskId($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeCheckFixDetails extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getCheckWarningId()
 * @method $this withCheckWarningId($value)
 */
class DescribeCheckWarningDetail extends Rpc
{
}

/**
 * @method string getRiskId()
 * @method $this withRiskId($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getCheckId()
 * @method $this withCheckId($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class DescribeCheckWarningMachines extends Rpc
{
}

/**
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getCheckType()
 * @method $this withCheckType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getCheckId()
 * @method $this withCheckId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getRiskId()
 * @method $this withRiskId($value)
 * @method string getRiskStatus()
 * @method $this withRiskStatus($value)
 */
class DescribeCheckWarnings extends Rpc
{
}

/**
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method string getContainerFieldName()
 * @method $this withContainerFieldName($value)
 * @method string getRiskName()
 * @method $this withRiskName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getContainerFieldValue()
 * @method $this withContainerFieldValue($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getRiskLevel()
 * @method $this withRiskLevel($value)
 * @method string getRiskStatus()
 * @method $this withRiskStatus($value)
 * @method string getStrategyId()
 * @method $this withStrategyId($value)
 * @method string getTypeName()
 * @method $this withTypeName($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class DescribeCheckWarningSummary extends Rpc
{
}

/**
 * @method string getStrategyTagValue()
 * @method $this withStrategyTagValue($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getStrategyTag()
 * @method $this withStrategyTag($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DescribeClientConfSetup extends Rpc
{
}

/**
 * @method string getTagValue()
 * @method $this withTagValue($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getTag()
 * @method $this withTag($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DescribeClientConfStrategy extends Rpc
{
}

/**
 * @method string getCriteria()
 * @method $this withCriteria($value)
 * @method string getImportance()
 * @method $this withImportance($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getNoPage()
 * @method $this withNoPage($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLogicalExp()
 * @method $this withLogicalExp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getMachineTypes()
 * @method $this withMachineTypes($value)
 * @method string getNoGroupTrace()
 * @method $this withNoGroupTrace($value)
 */
class DescribeCloudCenterInstances extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeCloudProductFieldStatistics extends Rpc
{
}

/**
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeClusterBasicInfo extends Rpc
{
}

/**
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getTarget()
 * @method $this withTarget($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeClusterInfoList extends Rpc
{
}

/**
 * @method string getEndTime()
 * @method $this withEndTime($value)
 * @method string getStartTime()
 * @method $this withStartTime($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeClusterNetwork extends Rpc
{
}

/**
 * @method string getTypes()
 * @method $this withTypes($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeClusterVulStatistics extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DescribeCommonOverallConfig extends Rpc
{
}

/**
 * @method array getTypeList()
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeCommonOverallConfigList extends Rpc
{

    /**
     * @param array $typeList
     *
     * @return $this
     */
	public function withTypeList(array $typeList)
	{
	    $this->data['TypeList'] = $typeList;
		foreach ($typeList as $i => $iValue) {
			$this->options['query']['TypeList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeCommonTargetConfig extends Rpc
{
}

/**
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeCommonTargetResultList extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DescribeConcernNecessity extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getGroupField()
 * @method $this withGroupField($value)
 * @method string getValue()
 * @method $this withValue($value)
 */
class DescribeContainerCriteria extends Rpc
{
}

/**
 * @method string getCriteria()
 * @method $this withCriteria($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLogicalExp()
 * @method $this withLogicalExp($value)
 */
class DescribeContainerInstances extends Rpc
{
}

/**
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeContainerStatistics extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getAppName()
 * @method $this withAppName($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getFieldValue()
 * @method $this withFieldValue($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getFieldName()
 * @method $this withFieldName($value)
 * @method string getNamespace()
 * @method $this withNamespace($value)
 */
class DescribeContainerTags extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeCountNotScannedImage extends Rpc
{
}

class DescribeCountScannedImage extends Rpc
{
}

/**
 * @method string getSupportAutoTag()
 * @method $this withSupportAutoTag($value)
 * @method string getMachineTypes()
 * @method $this withMachineTypes($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getValue()
 * @method $this withValue($value)
 */
class DescribeCriteria extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getBlockIp()
 * @method $this withBlockIp($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class DescribeCustomBlockRecords extends Rpc
{
}

/**
 * @method string getTaskName()
 * @method $this withTaskName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 * @method string getTaskType()
 * @method $this withTaskType($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 */
class DescribeCycleTaskList extends Rpc
{
}

/**
 * @method string getRuleActionName()
 * @method $this withRuleActionName($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 */
class DescribeDingTalk extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeDomainCount extends Rpc
{
}

/**
 * @method string getDomainName()
 * @method $this withDomainName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeDomainDetail extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getFuzzyDomain()
 * @method $this withFuzzyDomain($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getDomainType()
 * @method $this withDomainType($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 */
class DescribeDomainList extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DescribeEmgUserAgreement extends Rpc
{
}

/**
 * @method string getScanType()
 * @method $this withScanType($value)
 * @method string getCheckType()
 * @method $this withCheckType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCheckStatus()
 * @method $this withCheckStatus($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getVulName()
 * @method $this withVulName($value)
 * @method string getRiskStatus()
 * @method $this withRiskStatus($value)
 */
class DescribeEmgVulItem extends Rpc
{
}

/**
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getContainerFieldName()
 * @method $this withContainerFieldName($value)
 * @method string getContainerFieldValue()
 * @method $this withContainerFieldValue($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getContainerIds()
 * @method $this withContainerIds($value)
 */
class DescribeEventLevelCount extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeEventOnStage extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 */
class DescribeExcludeSystemPath extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getExportId()
 * @method $this withExportId($value)
 */
class DescribeExportInfo extends Rpc
{
}

/**
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getTypeName()
 * @method $this withTypeName($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class DescribeExposedCheckWarning extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getValue()
 * @method $this withValue($value)
 */
class DescribeExposedInstanceCriteria extends Rpc
{
}

/**
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeExposedInstanceDetail extends Rpc
{
}

/**
 * @method string getExposurePort()
 * @method $this withExposurePort($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getVulStatus()
 * @method $this withVulStatus($value)
 * @method string getExposureIp()
 * @method $this withExposureIp($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getExposureComponent()
 * @method $this withExposureComponent($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 * @method string getInstanceName()
 * @method $this withInstanceName($value)
 * @method string getHealthStatus()
 * @method $this withHealthStatus($value)
 */
class DescribeExposedInstanceList extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeExposedStatistics extends Rpc
{
}

/**
 * @method string getStatisticsType()
 * @method $this withStatisticsType($value)
 * @method string getStatisticsTypeGatewayType()
 * @method $this withStatisticsTypeGatewayType($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getStatisticsTypeInstanceValue()
 * @method $this withStatisticsTypeInstanceValue($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 */
class DescribeExposedStatisticsDetail extends Rpc
{
}

/**
 * @method string getMachineTypes()
 * @method $this withMachineTypes($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeFieldStatistics extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getOperateType()
 * @method $this withOperateType($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getInfo()
 * @method $this withInfo($value)
 */
class DescribeFrontVulPatchList extends Rpc
{
}

/**
 * @method string getCriteria()
 * @method $this withCriteria($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getGroupField()
 * @method $this withGroupField($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLogicalExp()
 * @method $this withLogicalExp($value)
 * @method string getFieldValue()
 * @method $this withFieldValue($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 */
class DescribeGroupedContainerInstances extends Rpc
{
}

/**
 * @method string getCriteria()
 * @method $this withCriteria($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getGroupField()
 * @method $this withGroupField($value)
 * @method string getNoPage()
 * @method $this withNoPage($value)
 * @method string getVendor()
 * @method $this withVendor($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getVendors()
 * @method $this withVendors($value)
 * @method string getFieldValue()
 * @method $this withFieldValue($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getMachineTypes()
 * @method $this withMachineTypes($value)
 */
class DescribeGroupedInstances extends Rpc
{
}

/**
 * @method string getRepoId()
 * @method $this withRepoId($value)
 * @method string getFuzzyMaliciousName()
 * @method $this withFuzzyMaliciousName($value)
 * @method string getRepoNamespace()
 * @method $this withRepoNamespace($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getImageDigest()
 * @method $this withImageDigest($value)
 * @method array getScanRange()
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getImageTag()
 * @method $this withImageTag($value)
 * @method string getMaliciousMd5()
 * @method $this withMaliciousMd5($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getRepoName()
 * @method $this withRepoName($value)
 * @method string getRepoInstanceId()
 * @method $this withRepoInstanceId($value)
 * @method string getImageLayer()
 * @method $this withImageLayer($value)
 * @method string getLevels()
 * @method $this withLevels($value)
 * @method string getRepoRegionId()
 * @method $this withRepoRegionId($value)
 * @method array getUuids()
 */
class DescribeGroupedMaliciousFiles extends Rpc
{

    /**
     * @param array $scanRange
     *
     * @return $this
     */
	public function withScanRange(array $scanRange)
	{
	    $this->data['ScanRange'] = $scanRange;
		foreach ($scanRange as $i => $iValue) {
			$this->options['query']['ScanRange.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $uuids
     *
     * @return $this
     */
	public function withUuids(array $uuids)
	{
	    $this->data['Uuids'] = $uuids;
		foreach ($uuids as $i => $iValue) {
			$this->options['query']['Uuids.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getMachineTypes()
 * @method $this withMachineTypes($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeGroupedTags extends Rpc
{
}

/**
 * @method string getStatusList()
 * @method $this withStatusList($value)
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method string getMinScore()
 * @method $this withMinScore($value)
 * @method string getCveId()
 * @method $this withCveId($value)
 * @method string getAttachTypes()
 * @method $this withAttachTypes($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getVpcInstanceIds()
 * @method $this withVpcInstanceIds($value)
 * @method string getLastTsEnd()
 * @method $this withLastTsEnd($value)
 * @method string getCreateTsStart()
 * @method $this withCreateTsStart($value)
 * @method string getContainerFieldName()
 * @method $this withContainerFieldName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getContainerFieldValue()
 * @method $this withContainerFieldValue($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getLastTsStart()
 * @method $this withLastTsStart($value)
 * @method string getAssetType()
 * @method $this withAssetType($value)
 * @method string getDirection()
 * @method $this withDirection($value)
 * @method string getLevel()
 * @method $this withLevel($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getOrderBy()
 * @method $this withOrderBy($value)
 * @method string getDealed()
 * @method $this withDealed($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getPatchId()
 * @method $this withPatchId($value)
 * @method string getAliasName()
 * @method $this withAliasName($value)
 * @method string getSearchTags()
 * @method $this withSearchTags($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getCreateTsEnd()
 * @method $this withCreateTsEnd($value)
 * @method string getNecessity()
 * @method $this withNecessity($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class DescribeGroupedVul extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeGroupStruct extends Rpc
{
}

/**
 * @method string getExportId()
 * @method $this withExportId($value)
 */
class DescribeHcExportInfo extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeHoneyPotAuth extends Rpc
{
}

/**
 * @method string getStatisticsDays()
 * @method $this withStatisticsDays($value)
 * @method string getStatisticsKeyType()
 * @method $this withStatisticsKeyType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 */
class DescribeHoneyPotSuspStatistics extends Rpc
{
}

/**
 * @method string getImageInstanceId()
 * @method $this withImageInstanceId($value)
 * @method string getImageRegionId()
 * @method $this withImageRegionId($value)
 * @method string getImageRepoId()
 * @method $this withImageRepoId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getImageTag()
 * @method $this withImageTag($value)
 */
class DescribeImage extends Rpc
{
}

/**
 * @method string getCriteria()
 * @method $this withCriteria($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method array getScanRange()
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCriteriaType()
 * @method $this withCriteriaType($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getImageUuid()
 * @method $this withImageUuid($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getRiskLevel()
 * @method $this withRiskLevel($value)
 */
class DescribeImageBaselineCheckResult extends Rpc
{

    /**
     * @param array $scanRange
     *
     * @return $this
     */
	public function withScanRange(array $scanRange)
	{
	    $this->data['ScanRange'] = $scanRange;
		foreach ($scanRange as $i => $iValue) {
			$this->options['query']['ScanRange.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getCriteria()
 * @method $this withCriteria($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method array getScanRange()
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCriteriaType()
 * @method $this withCriteriaType($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getRiskLevel()
 * @method $this withRiskLevel($value)
 */
class DescribeImageBaselineCheckSummary extends Rpc
{

    /**
     * @param array $scanRange
     *
     * @return $this
     */
	public function withScanRange(array $scanRange)
	{
	    $this->data['ScanRange'] = $scanRange;
		foreach ($scanRange as $i => $iValue) {
			$this->options['query']['ScanRange.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getImageUuid()
 * @method $this withImageUuid($value)
 * @method string getBaselineItemKey()
 * @method $this withBaselineItemKey($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeImageBaselineDetail extends Rpc
{
}

/**
 * @method string getBaselineClassKey()
 * @method $this withBaselineClassKey($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method array getScanRange()
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getImageUuid()
 * @method $this withImageUuid($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getBaselineNameKey()
 * @method $this withBaselineNameKey($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 * @method array getUuids()
 */
class DescribeImageBaselineItemList extends Rpc
{

    /**
     * @param array $scanRange
     *
     * @return $this
     */
	public function withScanRange(array $scanRange)
	{
	    $this->data['ScanRange'] = $scanRange;
		foreach ($scanRange as $i => $iValue) {
			$this->options['query']['ScanRange.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $uuids
     *
     * @return $this
     */
	public function withUuids(array $uuids)
	{
	    $this->data['Uuids'] = $uuids;
		foreach ($uuids as $i => $iValue) {
			$this->options['query']['Uuids.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getStrategyId()
 * @method $this withStrategyId($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeImageBaselineStrategy extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getValue()
 * @method $this withValue($value)
 */
class DescribeImageCriteria extends Rpc
{
}

/**
 * @method string getEndTime()
 * @method $this withEndTime($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getStartTime()
 * @method $this withStartTime($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class DescribeImageFixTask extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getLastTsEnd()
 * @method $this withLastTsEnd($value)
 * @method string getCreateTsStart()
 * @method $this withCreateTsStart($value)
 * @method string getIsLatest()
 * @method $this withIsLatest($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getImageTag()
 * @method $this withImageTag($value)
 * @method string getLevel()
 * @method $this withLevel($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getOrderBy()
 * @method $this withOrderBy($value)
 * @method string getAliasName()
 * @method $this withAliasName($value)
 * @method string getPatchId()
 * @method $this withPatchId($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getCreateTsEnd()
 * @method $this withCreateTsEnd($value)
 * @method string getNecessity()
 * @method $this withNecessity($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 * @method string getRepoId()
 * @method $this withRepoId($value)
 * @method string getStatusList()
 * @method $this withStatusList($value)
 * @method string getCveId()
 * @method $this withCveId($value)
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getRepoNamespace()
 * @method $this withRepoNamespace($value)
 * @method string getImageDigest()
 * @method $this withImageDigest($value)
 * @method array getScanRange()
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getLastTsStart()
 * @method $this withLastTsStart($value)
 * @method string getDirection()
 * @method $this withDirection($value)
 * @method string getDealed()
 * @method $this withDealed($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getSearchTags()
 * @method $this withSearchTags($value)
 * @method string getRepoName()
 * @method $this withRepoName($value)
 * @method string getRepoInstanceId()
 * @method $this withRepoInstanceId($value)
 * @method string getImageLayer()
 * @method $this withImageLayer($value)
 * @method string getRepoRegionId()
 * @method $this withRepoRegionId($value)
 */
class DescribeImageGroupedVulList extends Rpc
{

    /**
     * @param array $scanRange
     *
     * @return $this
     */
	public function withScanRange(array $scanRange)
	{
	    $this->data['ScanRange'] = $scanRange;
		foreach ($scanRange as $i => $iValue) {
			$this->options['query']['ScanRange.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class DescribeImageInfoList extends Rpc
{
}

/**
 * @method string getCriteria()
 * @method $this withCriteria($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getScanned()
 * @method $this withScanned($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLogicalExp()
 * @method $this withLogicalExp($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 */
class DescribeImageInstances extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getDigest()
 * @method $this withDigest($value)
 */
class DescribeImageLatestScanTask extends Rpc
{
}

/**
 * @method string getSensitiveFileKey()
 * @method $this withSensitiveFileKey($value)
 * @method string getRepoNamespace()
 * @method $this withRepoNamespace($value)
 * @method string getImageDigest()
 * @method $this withImageDigest($value)
 * @method string getScanRange()
 * @method $this withScanRange($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getRiskLevel()
 * @method $this withRiskLevel($value)
 * @method string getRepoName()
 * @method $this withRepoName($value)
 * @method string getRepoInstanceId()
 * @method $this withRepoInstanceId($value)
 */
class DescribeImageListBySensitiveFile extends Rpc
{
}

/**
 * @method string getPod()
 * @method $this withPod($value)
 * @method string getClusterName()
 * @method $this withClusterName($value)
 * @method string getCriteria()
 * @method $this withCriteria($value)
 * @method string getRepoNamespace()
 * @method $this withRepoNamespace($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getImageDigest()
 * @method $this withImageDigest($value)
 * @method array getScanRange()
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCriteriaType()
 * @method $this withCriteriaType($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getImage()
 * @method $this withImage($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getRepoName()
 * @method $this withRepoName($value)
 * @method string getNamespace()
 * @method $this withNamespace($value)
 * @method string getBaselineNameKey()
 * @method $this withBaselineNameKey($value)
 * @method string getRepoInstanceId()
 * @method $this withRepoInstanceId($value)
 * @method string getContainerId()
 * @method $this withContainerId($value)
 */
class DescribeImageListWithBaselineName extends Rpc
{

    /**
     * @param array $scanRange
     *
     * @return $this
     */
	public function withScanRange(array $scanRange)
	{
	    $this->data['ScanRange'] = $scanRange;
		foreach ($scanRange as $i => $iValue) {
			$this->options['query']['ScanRange.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getValue()
 * @method $this withValue($value)
 */
class DescribeImageRepoCriteria extends Rpc
{
}

/**
 * @method string getCriteria()
 * @method $this withCriteria($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLogicalExp()
 * @method $this withLogicalExp($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 */
class DescribeImageRepoDetailList extends Rpc
{
}

/**
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getRepoNamespace()
 * @method $this withRepoNamespace($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getFieldValue()
 * @method $this withFieldValue($value)
 * @method string getFieldName()
 * @method $this withFieldName($value)
 * @method string getRepoName()
 * @method $this withRepoName($value)
 * @method string getOperateType()
 * @method $this withOperateType($value)
 */
class DescribeImageRepoList extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeImageScanAuthCount extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeImageScanAuthorization extends Rpc
{
}

/**
 * @method string getSensitiveFileKey()
 * @method $this withSensitiveFileKey($value)
 * @method string getScanRange()
 * @method $this withScanRange($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getImageUuid()
 * @method $this withImageUuid($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 */
class DescribeImageSensitiveFileByKey extends Rpc
{
}

/**
 * @method string getCriteria()
 * @method $this withCriteria($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getScanRange()
 * @method $this withScanRange($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCriteriaType()
 * @method $this withCriteriaType($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getImageUuid()
 * @method $this withImageUuid($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getRiskLevel()
 * @method $this withRiskLevel($value)
 */
class DescribeImageSensitiveFileList extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeImageStatistics extends Rpc
{
}

/**
 * @method string getClusterName()
 * @method $this withClusterName($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getCreateTsStart()
 * @method $this withCreateTsStart($value)
 * @method string getContainerFieldName()
 * @method $this withContainerFieldName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getTag()
 * @method $this withTag($value)
 * @method string getModifyTsEnd()
 * @method $this withModifyTsEnd($value)
 * @method string getImage()
 * @method $this withImage($value)
 * @method string getLevel()
 * @method $this withLevel($value)
 * @method string getResource()
 * @method $this withResource($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getAliasName()
 * @method $this withAliasName($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getIds()
 * @method $this withIds($value)
 * @method string getCreateTsEnd()
 * @method $this withCreateTsEnd($value)
 * @method string getContainerId()
 * @method $this withContainerId($value)
 * @method string getNecessity()
 * @method $this withNecessity($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 * @method string getRepoId()
 * @method $this withRepoId($value)
 * @method string getStatusList()
 * @method $this withStatusList($value)
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method string getPod()
 * @method $this withPod($value)
 * @method string getCveId()
 * @method $this withCveId($value)
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getRepoNamespace()
 * @method $this withRepoNamespace($value)
 * @method string getContainerFieldValue()
 * @method $this withContainerFieldValue($value)
 * @method array getScanRange()
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getDigest()
 * @method $this withDigest($value)
 * @method string getModifyTsStart()
 * @method $this withModifyTsStart($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getDealed()
 * @method $this withDealed($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getBatchName()
 * @method $this withBatchName($value)
 * @method string getRepoName()
 * @method $this withRepoName($value)
 * @method string getNamespace()
 * @method $this withNamespace($value)
 * @method string getRepoInstanceId()
 * @method $this withRepoInstanceId($value)
 * @method string getRepoRegionId()
 * @method $this withRepoRegionId($value)
 */
class DescribeImageVulList extends Rpc
{

    /**
     * @param array $scanRange
     *
     * @return $this
     */
	public function withScanRange(array $scanRange)
	{
	    $this->data['ScanRange'] = $scanRange;
		foreach ($scanRange as $i => $iValue) {
			$this->options['query']['ScanRange.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getDeadline()
 * @method $this withDeadline($value)
 */
class DescribeInstallCaptcha extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeInstallCode extends Rpc
{
}

/**
 * @method string getSubAccountName()
 * @method $this withSubAccountName($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class DescribeInstallCodes extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method array getUuidList()
 */
class DescribeInstanceAntiBruteForceRules extends Rpc
{

    /**
     * @param array $uuidList
     *
     * @return $this
     */
	public function withUuidList(array $uuidList)
	{
	    $this->data['UuidList'] = $uuidList;
		foreach ($uuidList as $i => $iValue) {
			$this->options['query']['UuidList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class DescribeInstanceRebootStatus extends Rpc
{
}

/**
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeInstanceStatistics extends Rpc
{
}

/**
 * @method string getIp()
 * @method $this withIp($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getSecurityEventId()
 * @method $this withSecurityEventId($value)
 */
class DescribeIpTags extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeLatestScanTask extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getTarget()
 * @method $this withTarget($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 */
class DescribeLoginBaseConfigs extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeLoginSwitchConfigs extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeLogMeta extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeLogShipperStatus extends Rpc
{
}

/**
 * @method string getLogVersion()
 * @method $this withLogVersion($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeLogstoreStorage extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeMachineCanReboot extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DescribeModuleConfig extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeNoticeConfig extends Rpc
{
}

/**
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getContainerFieldName()
 * @method $this withContainerFieldName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getContainerFieldValue()
 * @method $this withContainerFieldValue($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class DescribeNsasSuspEventType extends Rpc
{
}

/**
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getVendor()
 * @method $this withVendor($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getOs()
 * @method $this withOs($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getRegionNo()
 * @method $this withRegionNo($value)
 * @method string getRegionIdStr()
 * @method $this withRegionIdStr($value)
 */
class DescribeOfflineMachines extends Rpc
{
}

/**
 * @method array getStatusList()
 * @method string getSource()
 * @method $this withSource($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getRootTaskId()
 * @method $this withRootTaskId($value)
 * @method string getEndTimeQuery()
 * @method $this withEndTimeQuery($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getFinish()
 * @method $this withFinish($value)
 * @method string getTaskId()
 * @method $this withTaskId($value)
 * @method string getTaskType()
 * @method $this withTaskType($value)
 * @method string getStartTimeQuery()
 * @method $this withStartTimeQuery($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getTargetQuery()
 * @method $this withTargetQuery($value)
 */
class DescribeOnceTask extends Rpc
{

    /**
     * @param array $statusList
     *
     * @return $this
     */
	public function withStatusList(array $statusList)
	{
	    $this->data['StatusList'] = $statusList;
		foreach ($statusList as $i => $iValue) {
			$this->options['query']['StatusList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method array getStatusList()
 * @method string getSource()
 * @method $this withSource($value)
 * @method string getStartTime()
 * @method $this withStartTime($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getTaskId()
 * @method $this withTaskId($value)
 * @method string getTaskType()
 * @method $this withTaskType($value)
 * @method string getRelateInfo()
 * @method $this withRelateInfo($value)
 * @method string getEndTime()
 * @method $this withEndTime($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 */
class DescribeOnceTaskLeafRecordPage extends Rpc
{

    /**
     * @param array $statusList
     *
     * @return $this
     */
	public function withStatusList(array $statusList)
	{
	    $this->data['StatusList'] = $statusList;
		foreach ($statusList as $i => $iValue) {
			$this->options['query']['StatusList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuidList()
 * @method $this withUuidList($value)
 */
class DescribePropertyCount extends Rpc
{
}

/**
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getSource()
 * @method $this withSource($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getExtend()
 * @method $this withExtend($value)
 * @method string getUser()
 * @method $this withUser($value)
 */
class DescribePropertyCronDetail extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSource()
 * @method $this withSource($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getForceFlush()
 * @method $this withForceFlush($value)
 */
class DescribePropertyCronItem extends Rpc
{
}

/**
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getBindIp()
 * @method $this withBindIp($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getExtend()
 * @method $this withExtend($value)
 * @method string getPort()
 * @method $this withPort($value)
 * @method string getProcName()
 * @method $this withProcName($value)
 */
class DescribePropertyPortDetail extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPort()
 * @method $this withPort($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getForceFlush()
 * @method $this withForceFlush($value)
 */
class DescribePropertyPortItem extends Rpc
{
}

/**
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getCmdline()
 * @method $this withCmdline($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getProcTimeStart()
 * @method $this withProcTimeStart($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getProcTimeEnd()
 * @method $this withProcTimeEnd($value)
 * @method string getExtend()
 * @method $this withExtend($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getUser()
 * @method $this withUser($value)
 */
class DescribePropertyProcDetail extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getForceFlush()
 * @method $this withForceFlush($value)
 */
class DescribePropertyProcItem extends Rpc
{
}

/**
 * @method string getSearchItemSub()
 * @method $this withSearchItemSub($value)
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getPid()
 * @method $this withPid($value)
 * @method string getSearchItem()
 * @method $this withSearchItem($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getBiz()
 * @method $this withBiz($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getProcessStartedStart()
 * @method $this withProcessStartedStart($value)
 * @method string getProcessStartedEnd()
 * @method $this withProcessStartedEnd($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getScaVersion()
 * @method $this withScaVersion($value)
 * @method string getSearchInfoSub()
 * @method $this withSearchInfoSub($value)
 * @method string getSearchInfo()
 * @method $this withSearchInfo($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getBizType()
 * @method $this withBizType($value)
 * @method string getPort()
 * @method $this withPort($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getScaName()
 * @method $this withScaName($value)
 * @method string getScaNamePattern()
 * @method $this withScaNamePattern($value)
 * @method string getUser()
 * @method $this withUser($value)
 */
class DescribePropertyScaDetail extends Rpc
{
}

/**
 * @method string getSearchItem()
 * @method $this withSearchItem($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getBiz()
 * @method $this withBiz($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getForceFlush()
 * @method $this withForceFlush($value)
 * @method string getSearchInfo()
 * @method $this withSearchInfo($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getName()
 * @method $this withName($value)
 */
class DescribePropertyScaItem extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribePropertyScheduleConfig extends Rpc
{
}

/**
 * @method string getSoftwareVersion()
 * @method $this withSoftwareVersion($value)
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getPath()
 * @method $this withPath($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getInstallTimeStart()
 * @method $this withInstallTimeStart($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getInstallTimeEnd()
 * @method $this withInstallTimeEnd($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getExtend()
 * @method $this withExtend($value)
 * @method string getName()
 * @method $this withName($value)
 */
class DescribePropertySoftwareDetail extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getForceFlush()
 * @method $this withForceFlush($value)
 */
class DescribePropertySoftwareItem extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribePropertyTypeScaItem extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribePropertyUsageNewest extends Rpc
{
}

/**
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLastLoginTimeStart()
 * @method $this withLastLoginTimeStart($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getLastLoginTimeEnd()
 * @method $this withLastLoginTimeEnd($value)
 * @method string getExtend()
 * @method $this withExtend($value)
 * @method string getIsRoot()
 * @method $this withIsRoot($value)
 * @method string getUser()
 * @method $this withUser($value)
 */
class DescribePropertyUserDetail extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getUser()
 * @method $this withUser($value)
 * @method string getForceFlush()
 * @method $this withForceFlush($value)
 */
class DescribePropertyUserItem extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getQuaraFileId()
 * @method $this withQuaraFileId($value)
 */
class DescribeQuaraFileDownloadInfo extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getMachineRemark()
 * @method $this withMachineRemark($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class DescribeRestoreJobs extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getInstanceName()
 * @method $this withInstanceName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class DescribeRestorePlans extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getItemId()
 * @method $this withItemId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 */
class DescribeRiskCheckItemResult extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getAssetType()
 * @method $this withAssetType($value)
 * @method string getQueryFlag()
 * @method $this withQueryFlag($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method array getItemIds()
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getRiskLevel()
 * @method $this withRiskLevel($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class DescribeRiskCheckResult extends Rpc
{

    /**
     * @param array $itemIds
     *
     * @return $this
     */
	public function withItemIds(array $itemIds)
	{
	    $this->data['ItemIds'] = $itemIds;
		foreach ($itemIds as $i => $iValue) {
			$this->options['query']['ItemIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DescribeRiskCheckSummary extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeRiskItemType extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method array getInstanceIds()
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeRiskListCheckResult extends Rpc
{

    /**
     * @param array $instanceIds
     *
     * @return $this
     */
	public function withInstanceIds(array $instanceIds)
	{
	    $this->data['InstanceIds'] = $instanceIds;
		foreach ($instanceIds as $i => $iValue) {
			$this->options['query']['InstanceIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getRiskId()
 * @method $this withRiskId($value)
 * @method string getRiskName()
 * @method $this withRiskName($value)
 * @method string getLimit()
 * @method $this withLimit($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeRisks extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 * @method string getTypeName()
 * @method $this withTypeName($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class DescribeRiskType extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class DescribeSasPmAgentList extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getTaskId()
 * @method $this withTaskId($value)
 */
class DescribeScanTaskProgress extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLevels()
 * @method $this withLevels($value)
 */
class DescribeScanTaskStatistics extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeSearchCondition extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeSecureSuggestion extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeSecurityCheckScheduleConfig extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getSecurityEventId()
 * @method $this withSecurityEventId($value)
 */
class DescribeSecurityEventOperations extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method array getSecurityEventIds()
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getTaskId()
 * @method $this withTaskId($value)
 */
class DescribeSecurityEventOperationStatus extends Rpc
{

    /**
     * @param array $securityEventIds
     *
     * @return $this
     */
	public function withSecurityEventIds(array $securityEventIds)
	{
	    $this->data['SecurityEventIds'] = $securityEventIds;
		foreach ($securityEventIds as $i => $iValue) {
			$this->options['query']['SecurityEventIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DescribeSecurityStatInfo extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getServiceLinkedRole()
 * @method $this withServiceLinkedRole($value)
 */
class DescribeServiceLinkedRoleStatus extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getSecurityEventId()
 * @method $this withSecurityEventId($value)
 */
class DescribeSimilarEventScenarios extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getTaskId()
 * @method $this withTaskId($value)
 */
class DescribeSimilarSecurityEvents extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getStatusList()
 * @method $this withStatusList($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getMachineRemark()
 * @method $this withMachineRemark($value)
 * @method string getNextToken()
 * @method $this withNextToken($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getApiVersion()
 * @method $this withApiVersion($value)
 * @method string getMachineRegion()
 * @method $this withMachineRegion($value)
 * @method string getIsAliYunEcs()
 * @method $this withIsAliYunEcs($value)
 */
class DescribeSnapshots extends Rpc
{
}

/**
 * @method string getCustomType()
 * @method $this withCustomType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getStrategyIds()
 * @method $this withStrategyIds($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DescribeStrategy extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getId()
 * @method $this withId($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DescribeStrategyDetail extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getStrategyId()
 * @method $this withStrategyId($value)
 */
class DescribeStrategyExecDetail extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getConfig()
 * @method $this withConfig($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DescribeStrategyTarget extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DescribeSummaryInfo extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeSupportRegion extends Rpc
{
}

/**
 * @method string getSuspiciousEventId()
 * @method $this withSuspiciousEventId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeSuspEventDetail extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getExportId()
 * @method $this withExportId($value)
 */
class DescribeSuspEventExportInfo extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getGroupingId()
 * @method $this withGroupingId($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getQuaraTag()
 * @method $this withQuaraTag($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class DescribeSuspEventQuaraFiles extends Rpc
{
}

/**
 * @method string getSource()
 * @method $this withSource($value)
 * @method string getContainerFieldName()
 * @method $this withContainerFieldName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getEventNames()
 * @method $this withEventNames($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getId()
 * @method $this withId($value)
 * @method string getTacticId()
 * @method string getAlarmUniqueInfo()
 * @method $this withAlarmUniqueInfo($value)
 * @method string getUniqueInfo()
 * @method $this withUniqueInfo($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getOperateTimeEnd()
 * @method $this withOperateTimeEnd($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 * @method string getTimeEnd()
 * @method $this withTimeEnd($value)
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method string getSortType()
 * @method $this withSortType($value)
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getContainerFieldValue()
 * @method $this withContainerFieldValue($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getDealed()
 * @method $this withDealed($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method array getOperateErrorCodeList()
 * @method string getSortColumn()
 * @method $this withSortColumn($value)
 * @method array getAssetsTypeList()
 * @method string getOperateTimeStart()
 * @method $this withOperateTimeStart($value)
 * @method string getTimeStart()
 * @method $this withTimeStart($value)
 * @method string getLevels()
 * @method $this withLevels($value)
 * @method string getParentEventTypes()
 * @method $this withParentEventTypes($value)
 */
class DescribeSuspEvents extends Rpc
{

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withTacticId($value)
    {
        $this->data['TacticId'] = $value;
        $this->options['form_params']['TacticId'] = $value;

        return $this;
    }

    /**
     * @param array $operateErrorCodeList
     *
     * @return $this
     */
	public function withOperateErrorCodeList(array $operateErrorCodeList)
	{
	    $this->data['OperateErrorCodeList'] = $operateErrorCodeList;
		foreach ($operateErrorCodeList as $i => $iValue) {
			$this->options['query']['OperateErrorCodeList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $assetsTypeList
     *
     * @return $this
     */
	public function withAssetsTypeList(array $assetsTypeList)
	{
	    $this->data['AssetsTypeList'] = $assetsTypeList;
		foreach ($assetsTypeList as $i => $iValue) {
			$this->options['query']['AssetsTypeList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getId()
 * @method $this withId($value)
 */
class DescribeSuspEventUserSetting extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DescribeSuspiciousOverallConfig extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DescribeSuspiciousUUIDConfig extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getConfig()
 * @method $this withConfig($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DescribeTarget extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getBuildTaskId()
 * @method $this withBuildTaskId($value)
 */
class DescribeTaskErrorLog extends Rpc
{
}

/**
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 */
class DescribeTotalStatistics extends Rpc
{
}

/**
 * @method string getVertexId()
 * @method $this withVertexId($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getIncidentTime()
 * @method $this withIncidentTime($value)
 */
class DescribeTraceInfoDetail extends Rpc
{
}

/**
 * @method string getVertexId()
 * @method $this withVertexId($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getEventName()
 * @method $this withEventName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getIncidentTime()
 * @method $this withIncidentTime($value)
 */
class DescribeTraceInfoNode extends Rpc
{
}

/**
 * @method string getDatabaseType()
 * @method $this withDatabaseType($value)
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getQueryType()
 * @method $this withQueryType($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getInstanceName()
 * @method $this withInstanceName($value)
 * @method string getUniRegionId()
 * @method $this withUniRegionId($value)
 */
class DescribeUniBackupDatabase extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getPolicyName()
 * @method $this withPolicyName($value)
 */
class DescribeUniBackupPolicies extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPolicyId()
 * @method $this withPolicyId($value)
 */
class DescribeUniBackupPolicyDetail extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getDatabase()
 * @method $this withDatabase($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPolicyId()
 * @method $this withPolicyId($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 */
class DescribeUniRecoverableList extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeUniSupportRegion extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeUserBackupMachines extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeUserBaselineAuthorization extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeUserLayoutAuthorization extends Rpc
{
}

/**
 * @method string getStatusList()
 * @method $this withStatusList($value)
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getVpcInstanceIds()
 * @method $this withVpcInstanceIds($value)
 * @method array getVulNames()
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getTag()
 * @method $this withTag($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getLevel()
 * @method $this withLevel($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getDealed()
 * @method $this withDealed($value)
 * @method string getFieldValue()
 * @method $this withFieldValue($value)
 * @method string getFieldName()
 * @method $this withFieldName($value)
 * @method string getSearchTags()
 * @method $this withSearchTags($value)
 * @method string getNecessity()
 * @method $this withNecessity($value)
 */
class DescribeUuidsByVulNames extends Rpc
{

    /**
     * @param array $vulNames
     *
     * @return $this
     */
	public function withVulNames(array $vulNames)
	{
	    $this->data['VulNames'] = $vulNames;
		foreach ($vulNames as $i => $iValue) {
			$this->options['query']['VulNames.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeVendorList extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DescribeVersionConfig extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeVpcHoneyPotCriteria extends Rpc
{
}

/**
 * @method string getVpcName()
 * @method $this withVpcName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getHoneyPotExistence()
 * @method $this withHoneyPotExistence($value)
 * @method string getVpcRegionId()
 * @method $this withVpcRegionId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getVpcId()
 * @method $this withVpcId($value)
 */
class DescribeVpcHoneyPotList extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeVpcList extends Rpc
{
}

/**
 * @method array getTypes()
 * @method array getTaskIds()
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeVulCheckTaskStatusDetail extends Rpc
{

    /**
     * @param array $types
     *
     * @return $this
     */
	public function withTypes(array $types)
	{
	    $this->data['Types'] = $types;
		foreach ($types as $i => $iValue) {
			$this->options['query']['Types.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $taskIds
     *
     * @return $this
     */
	public function withTaskIds(array $taskIds)
	{
	    $this->data['TaskIds'] = $taskIds;
		foreach ($taskIds as $i => $iValue) {
			$this->options['query']['TaskIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DescribeVulConfig extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getAliasName()
 * @method $this withAliasName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeVulDetails extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getExportId()
 * @method $this withExportId($value)
 */
class DescribeVulExportInfo extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeVulFixStatistics extends Rpc
{
}

/**
 * @method string getMinScore()
 * @method $this withMinScore($value)
 * @method string getAttachTypes()
 * @method $this withAttachTypes($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getVpcInstanceIds()
 * @method $this withVpcInstanceIds($value)
 * @method string getCreateTsStart()
 * @method $this withCreateTsStart($value)
 * @method string getContainerFieldName()
 * @method $this withContainerFieldName($value)
 * @method string getPath()
 * @method $this withPath($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getModifyTsEnd()
 * @method $this withModifyTsEnd($value)
 * @method string getLevel()
 * @method $this withLevel($value)
 * @method string getResource()
 * @method $this withResource($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getAliasName()
 * @method $this withAliasName($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getIds()
 * @method $this withIds($value)
 * @method string getCreateTsEnd()
 * @method $this withCreateTsEnd($value)
 * @method string getNecessity()
 * @method $this withNecessity($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 * @method string getStatusList()
 * @method $this withStatusList($value)
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method string getContainerName()
 * @method $this withContainerName($value)
 * @method string getCveId()
 * @method $this withCveId($value)
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getContainerFieldValue()
 * @method $this withContainerFieldValue($value)
 * @method string getImageName()
 * @method $this withImageName($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getModifyTsStart()
 * @method $this withModifyTsStart($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getAssetType()
 * @method $this withAssetType($value)
 * @method string getDealed()
 * @method $this withDealed($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getBatchName()
 * @method $this withBatchName($value)
 */
class DescribeVulList extends Rpc
{
}

/**
 * @method string getCveId()
 * @method $this withCveId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getVulNameLike()
 * @method $this withVulNameLike($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 */
class DescribeVulListPage extends Rpc
{
}

/**
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method string getStartTs()
 * @method $this withStartTs($value)
 * @method string getCreateTsStart()
 * @method $this withCreateTsStart($value)
 * @method string getContainerFieldName()
 * @method $this withContainerFieldName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getContainerFieldValue()
 * @method $this withContainerFieldValue($value)
 * @method string getEndTs()
 * @method $this withEndTs($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method array getNecessityList()
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getIncludeApp()
 * @method $this withIncludeApp($value)
 * @method string getCreateTsEnd()
 * @method $this withCreateTsEnd($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class DescribeVulNumStatistics extends Rpc
{

    /**
     * @param array $necessityList
     *
     * @return $this
     */
	public function withNecessityList(array $necessityList)
	{
	    $this->data['NecessityList'] = $necessityList;
		foreach ($necessityList as $i => $iValue) {
			$this->options['query']['NecessityList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeVulTargetConfig extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DescribeVulTargetStatistics extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 */
class DescribeVulWhitelist extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getExportId()
 * @method $this withExportId($value)
 */
class DescribeWarningExportInfo extends Rpc
{
}

/**
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method string getContainerFieldName()
 * @method $this withContainerFieldName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getContainerFieldValue()
 * @method $this withContainerFieldValue($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getMachineName()
 * @method $this withMachineName($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getHaveRisk()
 * @method $this withHaveRisk($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getRiskId()
 * @method $this withRiskId($value)
 * @method string getStrategyId()
 * @method $this withStrategyId($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class DescribeWarningMachines extends Rpc
{
}

/**
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class DescribeWebLockBindList extends Rpc
{
}

/**
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeWebLockConfigList extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeWebLockExclusiveFileType extends Rpc
{
}

/**
 * @method string getTsEnd()
 * @method $this withTsEnd($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getTsBegin()
 * @method $this withTsBegin($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 */
class DescribeWebLockFileChangeStatistics extends Rpc
{
}

/**
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getTsEnd()
 * @method $this withTsEnd($value)
 * @method string getProcessName()
 * @method $this withProcessName($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getDealed()
 * @method $this withDealed($value)
 * @method string getTsBegin()
 * @method $this withTsBegin($value)
 */
class DescribeWebLockFileEvents extends Rpc
{
}

/**
 * @method string getTsEnd()
 * @method $this withTsEnd($value)
 * @method string getTsBegin()
 * @method $this withTsBegin($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeWebLockFileTypeSummary extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeWebLockInclusiveFileType extends Rpc
{
}

/**
 * @method string getTsEnd()
 * @method $this withTsEnd($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getTsBegin()
 * @method $this withTsBegin($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 */
class DescribeWebLockProcessBlockStatistics extends Rpc
{
}

/**
 * @method string getProcessName()
 * @method $this withProcessName($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class DescribeWebLockProcessList extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeWebLockStatus extends Rpc
{
}

/**
 * @method string getTsEnd()
 * @method $this withTsEnd($value)
 * @method string getTsBegin()
 * @method $this withTsBegin($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeWebLockTotalFileChangeCount extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getTarget()
 * @method $this withTarget($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 */
class DescribeWebPath extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getBlockIp()
 * @method $this withBlockIp($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getId()
 * @method $this withId($value)
 * @method string getBound()
 * @method $this withBound($value)
 * @method string getPort()
 * @method $this withPort($value)
 */
class DisableBruteForceRecord extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getBound()
 * @method $this withBound($value)
 * @method string getBlockIp()
 * @method $this withBlockIp($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DisableCustomBlockRecord extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getBlockIp()
 * @method $this withBlockIp($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getId()
 * @method $this withId($value)
 * @method string getBound()
 * @method $this withBound($value)
 * @method string getPort()
 * @method $this withPort($value)
 */
class EnableBruteForceRecord extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getBound()
 * @method $this withBound($value)
 * @method string getBlockIp()
 * @method $this withBlockIp($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class EnableCustomBlockRecord extends Rpc
{
}

/**
 * @method string getStrategyId()
 * @method $this withStrategyId($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class ExecStrategy extends Rpc
{
}

/**
 * @method string getExportType()
 * @method $this withExportType($value)
 * @method string getParams()
 * @method $this withParams($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class ExportRecord extends Rpc
{
}

/**
 * @method string getTimeEnd()
 * @method $this withTimeEnd($value)
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getContainerFieldName()
 * @method $this withContainerFieldName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getContainerFieldValue()
 * @method $this withContainerFieldValue($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getDealed()
 * @method $this withDealed($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method array getAssetsTypeList()
 * @method string getName()
 * @method $this withName($value)
 * @method string getTimeStart()
 * @method $this withTimeStart($value)
 * @method string getLevels()
 * @method $this withLevels($value)
 * @method string getParentEventTypes()
 * @method $this withParentEventTypes($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class ExportSuspEvents extends Rpc
{

    /**
     * @param array $assetsTypeList
     *
     * @return $this
     */
	public function withAssetsTypeList(array $assetsTypeList)
	{
	    $this->data['AssetsTypeList'] = $assetsTypeList;
		foreach ($assetsTypeList as $i => $iValue) {
			$this->options['query']['AssetsTypeList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getStatusList()
 * @method $this withStatusList($value)
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method string getMinScore()
 * @method $this withMinScore($value)
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getAttachTypes()
 * @method $this withAttachTypes($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getVpcInstanceIds()
 * @method $this withVpcInstanceIds($value)
 * @method string getContainerFieldName()
 * @method $this withContainerFieldName($value)
 * @method string getCheckType()
 * @method $this withCheckType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getContainerFieldValue()
 * @method $this withContainerFieldValue($value)
 * @method string getModifyTsStart()
 * @method $this withModifyTsStart($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getModifyTsEnd()
 * @method $this withModifyTsEnd($value)
 * @method string getLevel()
 * @method $this withLevel($value)
 * @method string getResource()
 * @method $this withResource($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getDealed()
 * @method $this withDealed($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getBatchName()
 * @method $this withBatchName($value)
 * @method string getAliasName()
 * @method $this withAliasName($value)
 * @method string getSearchTags()
 * @method $this withSearchTags($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getNecessity()
 * @method $this withNecessity($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class ExportVul extends Rpc
{
}

/**
 * @method string getIsCleartextPwd()
 * @method $this withIsCleartextPwd($value)
 * @method string getStatusList()
 * @method $this withStatusList($value)
 * @method string getRiskLevels()
 * @method $this withRiskLevels($value)
 * @method string getRiskName()
 * @method $this withRiskName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getExportType()
 * @method $this withExportType($value)
 * @method string getDealed()
 * @method $this withDealed($value)
 * @method string getTypeNames()
 * @method $this withTypeNames($value)
 * @method string getIsSummaryExport()
 * @method $this withIsSummaryExport($value)
 * @method string getRiskIds()
 * @method $this withRiskIds($value)
 * @method string getStrategyId()
 * @method $this withStrategyId($value)
 * @method string getTypeName()
 * @method $this withTypeName($value)
 * @method string getSubTypeNames()
 * @method $this withSubTypeNames($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class ExportWarning extends Rpc
{
}

/**
 * @method string getDstNode()
 * @method $this withDstNode($value)
 * @method string getStartTime()
 * @method $this withStartTime($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCriteriaType()
 * @method $this withCriteriaType($value)
 * @method string getEndTime()
 * @method $this withEndTime($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSrcNode()
 * @method $this withSrcNode($value)
 */
class FindContainerNetworkConnect extends Rpc
{
}

/**
 * @method string getRiskId()
 * @method $this withRiskId($value)
 * @method string getCheckParams()
 * @method $this withCheckParams($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class FixCheckWarnings extends Rpc
{
}

/**
 * @method string getTaskName()
 * @method $this withTaskName($value)
 * @method string getSource()
 * @method $this withSource($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getParam()
 * @method $this withParam($value)
 * @method string getTaskType()
 * @method $this withTaskType($value)
 */
class GenerateOnceTask extends Rpc
{
}

/**
 * @method string getFrom()
 * @method $this withFrom($value)
 */
class GetAlarmMachineCount extends Rpc
{
}

/**
 * @method string getEndTime()
 * @method $this withEndTime($value)
 * @method string getStartTime()
 * @method $this withStartTime($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 */
class GetAppNetwork extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getBiz()
 * @method $this withBiz($value)
 * @method string getMaxId()
 * @method $this withMaxId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method array getSearchCriteriaList()
 * @method string getItemName()
 * @method $this withItemName($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 */
class GetAssetsPropertyDetail extends Rpc
{

    /**
     * @param array $searchCriteriaList
     *
     * @return $this
     */
	public function withSearchCriteriaList(array $searchCriteriaList)
	{
	    $this->data['SearchCriteriaList'] = $searchCriteriaList;
		foreach ($searchCriteriaList as $depth1 => $depth1Value) {
			if(isset($depth1Value['Name'])){
				$this->options['query']['SearchCriteriaList.' . ($depth1 + 1) . '.Name'] = $depth1Value['Name'];
			}
			if(isset($depth1Value['Value'])){
				$this->options['query']['SearchCriteriaList.' . ($depth1 + 1) . '.Value'] = $depth1Value['Value'];
			}
		}

		return $this;
    }
}

/**
 * @method string getSearchItem()
 * @method $this withSearchItem($value)
 * @method string getBiz()
 * @method $this withBiz($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getForceFlush()
 * @method $this withForceFlush($value)
 * @method string getSearchInfo()
 * @method $this withSearchInfo($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 */
class GetAssetsPropertyItem extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class GetBackupStorageCount extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getCheckGroupId()
 * @method $this withCheckGroupId($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class GetCheckConfig extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getCheckId()
 * @method $this withCheckId($value)
 */
class GetCheckDetail extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getTaskId()
 * @method $this withTaskId($value)
 */
class GetCheckProcess extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class GetCheckRiskStatistics extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class GetCheckSummary extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getId()
 * @method $this withId($value)
 */
class GetClientUserDefineRule extends Rpc
{
}

/**
 * @method array getCloudAssetTypes()
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getValue()
 * @method $this withValue($value)
 */
class GetCloudAssetCriteria extends Rpc
{

    /**
     * @param array $cloudAssetTypes
     *
     * @return $this
     */
	public function withCloudAssetTypes(array $cloudAssetTypes)
	{
	    $this->data['CloudAssetTypes'] = $cloudAssetTypes;
		foreach ($cloudAssetTypes as $depth1 => $depth1Value) {
			if(isset($depth1Value['AssetSubType'])){
				$this->options['query']['CloudAssetTypes.' . ($depth1 + 1) . '.AssetSubType'] = $depth1Value['AssetSubType'];
			}
			if(isset($depth1Value['AssetType'])){
				$this->options['query']['CloudAssetTypes.' . ($depth1 + 1) . '.AssetType'] = $depth1Value['AssetType'];
			}
		}

		return $this;
    }
}

/**
 * @method array getCloudAssetInstances()
 * @method string getAssetSubType()
 * @method $this withAssetSubType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getVendor()
 * @method $this withVendor($value)
 * @method string getAssetType()
 * @method $this withAssetType($value)
 */
class GetCloudAssetDetail extends Rpc
{

    /**
     * @param array $cloudAssetInstances
     *
     * @return $this
     */
	public function withCloudAssetInstances(array $cloudAssetInstances)
	{
	    $this->data['CloudAssetInstances'] = $cloudAssetInstances;
		foreach ($cloudAssetInstances as $depth1 => $depth1Value) {
			if(isset($depth1Value['InstanceId'])){
				$this->options['query']['CloudAssetInstances.' . ($depth1 + 1) . '.InstanceId'] = $depth1Value['InstanceId'];
			}
			if(isset($depth1Value['RegionId'])){
				$this->options['query']['CloudAssetInstances.' . ($depth1 + 1) . '.RegionId'] = $depth1Value['RegionId'];
			}
		}

		return $this;
    }
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class GetCloudAssetSummary extends Rpc
{
}

/**
 * @method string getClusterId()
 * @method $this withClusterId($value)
 */
class GetClusterCheckItemWarningStatistics extends Rpc
{
}

/**
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class GetClusterRuleSummary extends Rpc
{
}

/**
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 */
class GetClusterSuspEventStatistics extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class GetFileDetectApiInvokeInfo extends Rpc
{
}

/**
 * @method array getHashKeyList()
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class GetFileDetectResult extends Rpc
{

    /**
     * @param array $hashKeyList
     *
     * @return $this
     */
	public function withHashKeyList(array $hashKeyList)
	{
	    $this->data['HashKeyList'] = $hashKeyList;
		foreach ($hashKeyList as $i => $iValue) {
			$this->options['query']['HashKeyList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getNodeId()
 * @method $this withNodeId($value)
 */
class GetHoneypotNode extends Rpc
{
}

/**
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getHoneypotPresetId()
 * @method $this withHoneypotPresetId($value)
 */
class GetHoneypotPreset extends Rpc
{
}

/**
 * @method string getProbeId()
 * @method $this withProbeId($value)
 */
class GetHoneypotProbe extends Rpc
{
}

/**
 * @method string getPastDay()
 * @method $this withPastDay($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class GetImageScanNumInPeriod extends Rpc
{
}

/**
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getRuleId()
 * @method $this withRuleId($value)
 */
class GetInterceptionRuleDetail extends Rpc
{
}

/**
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class GetInterceptionSummary extends Rpc
{
}

/**
 * @method string getTargetId()
 * @method $this withTargetId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class GetInterceptionTargetDetail extends Rpc
{
}

/**
 * @method string getTaskName()
 * @method $this withTaskName($value)
 * @method string getSource()
 * @method $this withSource($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getTaskType()
 * @method $this withTaskType($value)
 */
class GetLastOnceTaskInfo extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class GetModuleConfig extends Rpc
{
}

/**
 * @method string getTaskName()
 * @method $this withTaskName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getTaskId()
 * @method $this withTaskId($value)
 * @method string getTaskType()
 * @method $this withTaskType($value)
 */
class GetOnceTaskResultInfo extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class GetPropertyScheduleConfig extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class GetRulesCount extends Rpc
{
}

/**
 * @method string getGroupIdList()
 * @method $this withGroupIdList($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class GetSuspiciousStatistics extends Rpc
{
}

/**
 * @method string getTypeList()
 * @method $this withTypeList($value)
 * @method string getGroupIdList()
 * @method $this withGroupIdList($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class GetVulStatistics extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getVulWhitelistId()
 * @method $this withVulWhitelistId($value)
 */
class GetVulWhitelist extends Rpc
{
}

/**
 * @method string getMarkMissParam()
 * @method $this withMarkMissParam($value)
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method array getSecurityEventIds()
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getOperationCode()
 * @method $this withOperationCode($value)
 * @method string getOperationParams()
 * @method $this withOperationParams($value)
 * @method string getMarkBatch()
 * @method $this withMarkBatch($value)
 */
class HandleSecurityEvents extends Rpc
{

    /**
     * @param array $securityEventIds
     *
     * @return $this
     */
	public function withSecurityEventIds(array $securityEventIds)
	{
	    $this->data['SecurityEventIds'] = $securityEventIds;
		foreach ($securityEventIds as $i => $iValue) {
			$this->options['query']['SecurityEventIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getMarkMissParam()
 * @method $this withMarkMissParam($value)
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getOperationCode()
 * @method $this withOperationCode($value)
 * @method string getTaskId()
 * @method $this withTaskId($value)
 * @method string getOperationParams()
 * @method $this withOperationParams($value)
 */
class HandleSimilarSecurityEvents extends Rpc
{
}

/**
 * @method string getReason()
 * @method $this withReason($value)
 * @method array getCheckAndRiskTypeList()
 * @method string getType()
 * @method $this withType($value)
 * @method array getUuidList()
 * @method string getLang()
 * @method $this withLang($value)
 */
class IgnoreCheckItems extends Rpc
{

    /**
     * @param array $checkAndRiskTypeList
     *
     * @return $this
     */
	public function withCheckAndRiskTypeList(array $checkAndRiskTypeList)
	{
	    $this->data['CheckAndRiskTypeList'] = $checkAndRiskTypeList;
		foreach ($checkAndRiskTypeList as $depth1 => $depth1Value) {
			if(isset($depth1Value['RiskType'])){
				$this->options['query']['CheckAndRiskTypeList.' . ($depth1 + 1) . '.RiskType'] = $depth1Value['RiskType'];
			}
			if(isset($depth1Value['CheckId'])){
				$this->options['query']['CheckAndRiskTypeList.' . ($depth1 + 1) . '.CheckId'] = $depth1Value['CheckId'];
			}
		}

		return $this;
    }

    /**
     * @param array $uuidList
     *
     * @return $this
     */
	public function withUuidList(array $uuidList)
	{
	    $this->data['UuidList'] = $uuidList;
		foreach ($uuidList as $i => $iValue) {
			$this->options['query']['UuidList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getReason()
 * @method $this withReason($value)
 * @method string getCheckIds()
 * @method $this withCheckIds($value)
 * @method string getRiskId()
 * @method $this withRiskId($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getCheckWarningIds()
 * @method $this withCheckWarningIds($value)
 */
class IgnoreHcCheckWarnings extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getPolicyVersion()
 * @method $this withPolicyVersion($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method array getUuidList()
 */
class InstallBackupClient extends Rpc
{

    /**
     * @param array $uuidList
     *
     * @return $this
     */
	public function withUuidList(array $uuidList)
	{
	    $this->data['UuidList'] = $uuidList;
		foreach ($uuidList as $i => $iValue) {
			$this->options['query']['UuidList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getAgentAccessKey()
 * @method $this withAgentAccessKey($value)
 * @method string getAgentSecretKey()
 * @method $this withAgentSecretKey($value)
 * @method string getArgusVersion()
 * @method $this withArgusVersion($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method array getInstanceIdList()
 * @method array getUuidList()
 */
class InstallCloudMonitor extends Rpc
{

    /**
     * @param array $instanceIdList
     *
     * @return $this
     */
	public function withInstanceIdList(array $instanceIdList)
	{
	    $this->data['InstanceIdList'] = $instanceIdList;
		foreach ($instanceIdList as $i => $iValue) {
			$this->options['query']['InstanceIdList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $uuidList
     *
     * @return $this
     */
	public function withUuidList(array $uuidList)
	{
	    $this->data['UuidList'] = $uuidList;
		foreach ($uuidList as $i => $iValue) {
			$this->options['query']['UuidList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class InstallPmAgent extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPolicyId()
 * @method $this withPolicyId($value)
 */
class InstallUniBackupAgent extends Rpc
{
}

/**
 * @method array getProcessPaths()
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class JoinWebLockProcessWhiteList extends Rpc
{

    /**
     * @param array $processPaths
     *
     * @return $this
     */
	public function withProcessPaths(array $processPaths)
	{
	    $this->data['ProcessPaths'] = $processPaths;
		foreach ($processPaths as $i => $iValue) {
			$this->options['query']['ProcessPaths.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getNodeId()
 * @method $this withNodeId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 */
class ListAvailableHoneypot extends Rpc
{
}

/**
 * @method string getRegionIdKey()
 * @method $this withRegionIdKey($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getCheckId()
 * @method $this withCheckId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method array getSortTypes()
 * @method string getInstanceIdKey()
 * @method $this withInstanceIdKey($value)
 * @method string getInstanceNameKey()
 * @method $this withInstanceNameKey($value)
 * @method array getInstanceIds()
 * @method array getStatuses()
 */
class ListCheckInstanceResult extends Rpc
{

    /**
     * @param array $sortTypes
     *
     * @return $this
     */
	public function withSortTypes(array $sortTypes)
	{
	    $this->data['SortTypes'] = $sortTypes;
		foreach ($sortTypes as $i => $iValue) {
			$this->options['query']['SortTypes.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $instanceIds
     *
     * @return $this
     */
	public function withInstanceIds(array $instanceIds)
	{
	    $this->data['InstanceIds'] = $instanceIds;
		foreach ($instanceIds as $i => $iValue) {
			$this->options['query']['InstanceIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $statuses
     *
     * @return $this
     */
	public function withStatuses(array $statuses)
	{
	    $this->data['Statuses'] = $statuses;
		foreach ($statuses as $i => $iValue) {
			$this->options['query']['Statuses.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getRiskType()
 * @method $this withRiskType($value)
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getContainerFieldName()
 * @method $this withContainerFieldName($value)
 * @method string getContainerFieldValue()
 * @method $this withContainerFieldValue($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getCheckId()
 * @method $this withCheckId($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class ListCheckItemWarningMachine extends Rpc
{
}

/**
 * @method string getRiskType()
 * @method $this withRiskType($value)
 * @method string getContainerFieldName()
 * @method $this withContainerFieldName($value)
 * @method string getCheckType()
 * @method $this withCheckType($value)
 * @method string getContainerFieldValue()
 * @method $this withContainerFieldValue($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getCheckWarningStatus()
 * @method $this withCheckWarningStatus($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getCheckItemFuzzy()
 * @method $this withCheckItemFuzzy($value)
 * @method string getCheckLevel()
 * @method $this withCheckLevel($value)
 */
class ListCheckItemWarningSummary extends Rpc
{
}

/**
 * @method array getInstanceSubTypes()
 * @method array getStandardIds()
 * @method array getRiskLevels()
 * @method array getInstanceTypes()
 * @method string getCheckKey()
 * @method $this withCheckKey($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method array getVendors()
 * @method array getTypes()
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method array getRequirementIds()
 * @method array getSortTypes()
 * @method array getInstanceIds()
 * @method array getStatuses()
 */
class ListCheckResult extends Rpc
{

    /**
     * @param array $instanceSubTypes
     *
     * @return $this
     */
	public function withInstanceSubTypes(array $instanceSubTypes)
	{
	    $this->data['InstanceSubTypes'] = $instanceSubTypes;
		foreach ($instanceSubTypes as $i => $iValue) {
			$this->options['query']['InstanceSubTypes.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $standardIds
     *
     * @return $this
     */
	public function withStandardIds(array $standardIds)
	{
	    $this->data['StandardIds'] = $standardIds;
		foreach ($standardIds as $i => $iValue) {
			$this->options['query']['StandardIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $riskLevels
     *
     * @return $this
     */
	public function withRiskLevels(array $riskLevels)
	{
	    $this->data['RiskLevels'] = $riskLevels;
		foreach ($riskLevels as $i => $iValue) {
			$this->options['query']['RiskLevels.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $instanceTypes
     *
     * @return $this
     */
	public function withInstanceTypes(array $instanceTypes)
	{
	    $this->data['InstanceTypes'] = $instanceTypes;
		foreach ($instanceTypes as $i => $iValue) {
			$this->options['query']['InstanceTypes.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $vendors
     *
     * @return $this
     */
	public function withVendors(array $vendors)
	{
	    $this->data['Vendors'] = $vendors;
		foreach ($vendors as $i => $iValue) {
			$this->options['query']['Vendors.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $types
     *
     * @return $this
     */
	public function withTypes(array $types)
	{
	    $this->data['Types'] = $types;
		foreach ($types as $i => $iValue) {
			$this->options['query']['Types.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $requirementIds
     *
     * @return $this
     */
	public function withRequirementIds(array $requirementIds)
	{
	    $this->data['RequirementIds'] = $requirementIds;
		foreach ($requirementIds as $i => $iValue) {
			$this->options['query']['RequirementIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $sortTypes
     *
     * @return $this
     */
	public function withSortTypes(array $sortTypes)
	{
	    $this->data['SortTypes'] = $sortTypes;
		foreach ($sortTypes as $i => $iValue) {
			$this->options['query']['SortTypes.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $instanceIds
     *
     * @return $this
     */
	public function withInstanceIds(array $instanceIds)
	{
	    $this->data['InstanceIds'] = $instanceIds;
		foreach ($instanceIds as $i => $iValue) {
			$this->options['query']['InstanceIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $statuses
     *
     * @return $this
     */
	public function withStatuses(array $statuses)
	{
	    $this->data['Statuses'] = $statuses;
		foreach ($statuses as $i => $iValue) {
			$this->options['query']['Statuses.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method array getInstanceSubTypes()
 * @method array getInstanceTypes()
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method array getInstanceIds()
 * @method string getLang()
 * @method $this withLang($value)
 * @method array getVendors()
 */
class ListCheckStandard extends Rpc
{

    /**
     * @param array $instanceSubTypes
     *
     * @return $this
     */
	public function withInstanceSubTypes(array $instanceSubTypes)
	{
	    $this->data['InstanceSubTypes'] = $instanceSubTypes;
		foreach ($instanceSubTypes as $i => $iValue) {
			$this->options['query']['InstanceSubTypes.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $instanceTypes
     *
     * @return $this
     */
	public function withInstanceTypes(array $instanceTypes)
	{
	    $this->data['InstanceTypes'] = $instanceTypes;
		foreach ($instanceTypes as $i => $iValue) {
			$this->options['query']['InstanceTypes.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $instanceIds
     *
     * @return $this
     */
	public function withInstanceIds(array $instanceIds)
	{
	    $this->data['InstanceIds'] = $instanceIds;
		foreach ($instanceIds as $i => $iValue) {
			$this->options['query']['InstanceIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $vendors
     *
     * @return $this
     */
	public function withVendors(array $vendors)
	{
	    $this->data['Vendors'] = $vendors;
		foreach ($vendors as $i => $iValue) {
			$this->options['query']['Vendors.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method array getType()
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getName()
 * @method $this withName($value)
 */
class ListClientUserDefineRules extends Rpc
{

    /**
     * @param array $type
     *
     * @return $this
     */
	public function withType(array $type)
	{
	    $this->data['Type'] = $type;
		foreach ($type as $i => $iValue) {
			$this->options['query']['Type.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class ListClientUserDefineRuleTypes extends Rpc
{
}

/**
 * @method string getCriteria()
 * @method $this withCriteria($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLogicalExp()
 * @method $this withLogicalExp($value)
 * @method array getCloudAssetTypes()
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 */
class ListCloudAssetInstances extends Rpc
{

    /**
     * @param array $cloudAssetTypes
     *
     * @return $this
     */
	public function withCloudAssetTypes(array $cloudAssetTypes)
	{
	    $this->data['CloudAssetTypes'] = $cloudAssetTypes;
		foreach ($cloudAssetTypes as $depth1 => $depth1Value) {
			if(isset($depth1Value['AssetSubType'])){
				$this->options['query']['CloudAssetTypes.' . ($depth1 + 1) . '.AssetSubType'] = $depth1Value['AssetSubType'];
			}
			if(isset($depth1Value['AssetType'])){
				$this->options['query']['CloudAssetTypes.' . ($depth1 + 1) . '.AssetType'] = $depth1Value['AssetType'];
			}
		}

		return $this;
    }
}

/**
 * @method array getClusterIds()
 */
class ListClusterCnnfStatusDetail extends Rpc
{

    /**
     * @param array $clusterIds
     *
     * @return $this
     */
	public function withClusterIds(array $clusterIds)
	{
	    $this->data['ClusterIds'] = $clusterIds;
		foreach ($clusterIds as $i => $iValue) {
			$this->options['query']['ClusterIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getClusterName()
 * @method $this withClusterName($value)
 * @method string getClusterCNNFStatus()
 * @method $this withClusterCNNFStatus($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getSwitchOn()
 * @method $this withSwitchOn($value)
 */
class ListClusterInterceptionConfig extends Rpc
{
}

/**
 * @method string getHoneypotName()
 * @method $this withHoneypotName($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getNodeId()
 * @method $this withNodeId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getNodeName()
 * @method $this withNodeName($value)
 * @method array getHoneypotIds()
 */
class ListHoneypot extends Rpc
{

    /**
     * @param array $honeypotIds
     *
     * @return $this
     */
	public function withHoneypotIds(array $honeypotIds)
	{
	    $this->data['HoneypotIds'] = $honeypotIds;
		foreach ($honeypotIds as $i => $iValue) {
			$this->options['query']['HoneypotIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getSrcIp()
 * @method array getRiskLevelList()
 * @method string getPageSize()
 * @method string getDstIp()
 * @method string getDealed()
 * @method string getCurrentPage()
 * @method string getRequestId()
 */
class ListHoneypotAlarmEvents extends Rpc
{

    /** @var string */
    public $method = 'GET';

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withSrcIp($value)
    {
        $this->data['SrcIp'] = $value;
        $this->options['form_params']['SrcIp'] = $value;

        return $this;
    }

    /**
     * @param array $riskLevelList
     *
     * @return $this
     */
	public function withRiskLevelList(array $riskLevelList)
	{
	    $this->data['RiskLevelList'] = $riskLevelList;
		foreach ($riskLevelList as $i => $iValue) {
			$this->options['form_params']['RiskLevelList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withPageSize($value)
    {
        $this->data['PageSize'] = $value;
        $this->options['form_params']['PageSize'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withDstIp($value)
    {
        $this->data['DstIp'] = $value;
        $this->options['form_params']['DstIp'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withDealed($value)
    {
        $this->data['Dealed'] = $value;
        $this->options['form_params']['Dealed'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withCurrentPage($value)
    {
        $this->data['CurrentPage'] = $value;
        $this->options['form_params']['CurrentPage'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withRequestId($value)
    {
        $this->data['RequestId'] = $value;
        $this->options['form_params']['RequestId'] = $value;

        return $this;
    }
}

/**
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getNodeId()
 * @method $this withNodeId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getNodeName()
 * @method $this withNodeName($value)
 */
class ListHoneypotNode extends Rpc
{
}

/**
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getNodeId()
 * @method $this withNodeId($value)
 * @method string getPresetName()
 * @method $this withPresetName($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getNodeName()
 * @method $this withNodeName($value)
 * @method string getHoneypotImageName()
 * @method $this withHoneypotImageName($value)
 */
class ListHoneypotPreset extends Rpc
{
}

/**
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getProbeType()
 * @method $this withProbeType($value)
 * @method string getProbeStatus()
 * @method $this withProbeStatus($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getDisplayName()
 * @method $this withDisplayName($value)
 */
class ListHoneypotProbe extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class ListImageRegistryRegion extends Rpc
{
}

/**
 * @method string getAppName()
 * @method $this withAppName($value)
 * @method string getImageName()
 * @method $this withImageName($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getNamespace()
 * @method $this withNamespace($value)
 */
class ListImageRisk extends Rpc
{
}

/**
 * @method array getTypes()
 * @method array getStandardIds()
 * @method array getRequirementIds()
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class ListInstanceCatalog extends Rpc
{

    /**
     * @param array $types
     *
     * @return $this
     */
	public function withTypes(array $types)
	{
	    $this->data['Types'] = $types;
		foreach ($types as $i => $iValue) {
			$this->options['query']['Types.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $standardIds
     *
     * @return $this
     */
	public function withStandardIds(array $standardIds)
	{
	    $this->data['StandardIds'] = $standardIds;
		foreach ($standardIds as $i => $iValue) {
			$this->options['query']['StandardIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $requirementIds
     *
     * @return $this
     */
	public function withRequirementIds(array $requirementIds)
	{
	    $this->data['RequirementIds'] = $requirementIds;
		foreach ($requirementIds as $i => $iValue) {
			$this->options['query']['RequirementIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getStartTime()
 * @method $this withStartTime($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getHistoryName()
 * @method $this withHistoryName($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method array getInterceptionTypes()
 * @method string getEndTime()
 * @method $this withEndTime($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 */
class ListInterceptionHistory extends Rpc
{

    /**
     * @param array $interceptionTypes
     *
     * @return $this
     */
	public function withInterceptionTypes(array $interceptionTypes)
	{
	    $this->data['InterceptionTypes'] = $interceptionTypes;
		foreach ($interceptionTypes as $i => $iValue) {
			$this->options['query']['InterceptionTypes.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getCriteria()
 * @method $this withCriteria($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCriteriaType()
 * @method $this withCriteriaType($value)
 */
class ListInterceptionRulePage extends Rpc
{
}

/**
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method array getImageList()
 * @method array getTagList()
 * @method string getTargetName()
 * @method $this withTargetName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getAppName()
 * @method $this withAppName($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getNamespace()
 * @method $this withNamespace($value)
 */
class ListInterceptionTargetPage extends Rpc
{

    /**
     * @param array $imageList
     *
     * @return $this
     */
	public function withImageList(array $imageList)
	{
	    $this->data['ImageList'] = $imageList;
		foreach ($imageList as $i => $iValue) {
			$this->options['query']['ImageList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $tagList
     *
     * @return $this
     */
	public function withTagList(array $tagList)
	{
	    $this->data['TagList'] = $tagList;
		foreach ($tagList as $i => $iValue) {
			$this->options['query']['TagList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getTypes()
 * @method $this withTypes($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class ListPluginForUuid extends Rpc
{
}

/**
 * @method string getPodName()
 * @method $this withPodName($value)
 * @method string getAppName()
 * @method $this withAppName($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getNamespace()
 * @method $this withNamespace($value)
 */
class ListPodRisk extends Rpc
{
}

/**
 * @method string getRegistryType()
 * @method $this withRegistryType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class ListPrivateRegistryList extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class ListPrivateRegistryType extends Rpc
{
}

/**
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class ListRuleTargetAll extends Rpc
{
}

/**
 * @method array getRuleTypes()
 * @method string getSystemType()
 * @method $this withSystemType($value)
 * @method string getRuleName()
 * @method $this withRuleName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method array getAggregationIds()
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 */
class ListSystemAggregationRules extends Rpc
{

    /** @var string */
    public $method = 'GET';

    /**
     * @param array $ruleTypes
     *
     * @return $this
     */
	public function withRuleTypes(array $ruleTypes)
	{
	    $this->data['RuleTypes'] = $ruleTypes;
		foreach ($ruleTypes as $i => $iValue) {
			$this->options['query']['RuleTypes.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $aggregationIds
     *
     * @return $this
     */
	public function withAggregationIds(array $aggregationIds)
	{
	    $this->data['AggregationIds'] = $aggregationIds;
		foreach ($aggregationIds as $i => $iValue) {
			$this->options['query']['AggregationIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method array getRuleTypes()
 * @method string getSystemType()
 * @method $this withSystemType($value)
 * @method string getRuleName()
 * @method $this withRuleName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getIsContainer()
 * @method $this withIsContainer($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method array getAggregationIds()
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getBusinessSecondType()
 * @method $this withBusinessSecondType($value)
 */
class ListSystemClientRules extends Rpc
{

    /**
     * @param array $ruleTypes
     *
     * @return $this
     */
	public function withRuleTypes(array $ruleTypes)
	{
	    $this->data['RuleTypes'] = $ruleTypes;
		foreach ($ruleTypes as $i => $iValue) {
			$this->options['query']['RuleTypes.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $aggregationIds
     *
     * @return $this
     */
	public function withAggregationIds(array $aggregationIds)
	{
	    $this->data['AggregationIds'] = $aggregationIds;
		foreach ($aggregationIds as $i => $iValue) {
			$this->options['query']['AggregationIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class ListSystemClientRuleTypes extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class ListSystemRuleAggregationTypes extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getVendor()
 * @method $this withVendor($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getOs()
 * @method $this withOs($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getRegionNo()
 * @method $this withRegionNo($value)
 * @method string getRegionIdStr()
 * @method $this withRegionIdStr($value)
 */
class ListUninstallAegisMachines extends Rpc
{
}

/**
 * @method string getWebPath()
 * @method $this withWebPath($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 */
class ListUuidsByWebPath extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getAliasName()
 * @method $this withAliasName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 */
class ListVulAutoRepairConfig extends Rpc
{
}

/**
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method array getIdList()
 * @method string getId()
 * @method $this withId($value)
 */
class ModifyAccessKeyLeakDeal extends Rpc
{

    /**
     * @param array $idList
     *
     * @return $this
     */
	public function withIdList(array $idList)
	{
	    $this->data['IdList'] = $idList;
		foreach ($idList as $i => $iValue) {
			$this->options['query']['IdList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getForbiddenTime()
 * @method $this withForbiddenTime($value)
 * @method string getFailCount()
 * @method $this withFailCount($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getEnableSmartRule()
 * @method $this withEnableSmartRule($value)
 * @method array getUuidList()
 * @method string getId()
 * @method $this withId($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getSpan()
 * @method $this withSpan($value)
 * @method string getDefaultRule()
 * @method $this withDefaultRule($value)
 */
class ModifyAntiBruteForceRule extends Rpc
{

    /**
     * @param array $uuidList
     *
     * @return $this
     */
	public function withUuidList(array $uuidList)
	{
	    $this->data['UuidList'] = $uuidList;
		foreach ($uuidList as $i => $iValue) {
			$this->options['query']['UuidList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getCycle()
 * @method $this withCycle($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class ModifyAppVulScanCycle extends Rpc
{
}

/**
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class ModifyAssetGroup extends Rpc
{
}

/**
 * @method string getImportantCode()
 * @method $this withImportantCode($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuidList()
 * @method $this withUuidList($value)
 */
class ModifyAssetImportant extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getDays()
 * @method $this withDays($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class ModifyAutoDelConfig extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getServerType()
 * @method $this withServerType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method array getUuidList()
 * @method string getId()
 * @method $this withId($value)
 * @method string getPolicy()
 * @method $this withPolicy($value)
 * @method string getPolicyVersion()
 * @method $this withPolicyVersion($value)
 * @method string getPolicyRegionId()
 * @method $this withPolicyRegionId($value)
 * @method string getName()
 * @method $this withName($value)
 */
class ModifyBackupPolicy extends Rpc
{

    /**
     * @param array $uuidList
     *
     * @return $this
     */
	public function withUuidList(array $uuidList)
	{
	    $this->data['UuidList'] = $uuidList;
		foreach ($uuidList as $i => $iValue) {
			$this->options['query']['UuidList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getPolicyVersion()
 * @method $this withPolicyVersion($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getId()
 * @method $this withId($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class ModifyBackupPolicyStatus extends Rpc
{
}

/**
 * @method string getUserLogStore()
 * @method $this withUserLogStore($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUserProject()
 * @method $this withUserProject($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class ModifyClearLogstoreStorage extends Rpc
{
}

/**
 * @method string getStrategyConfig()
 * @method $this withStrategyConfig($value)
 * @method string getStrategyTagValue()
 * @method $this withStrategyTagValue($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getStrategyTag()
 * @method $this withStrategyTag($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class ModifyClientConfSetup extends Rpc
{
}

/**
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getTag()
 * @method $this withTag($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 * @method string getTagValue()
 * @method $this withTagValue($value)
 * @method string getTagExt()
 * @method $this withTagExt($value)
 * @method array getUuids()
 */
class ModifyClientConfStrategy extends Rpc
{

    /**
     * @param array $uuids
     *
     * @return $this
     */
	public function withUuids(array $uuids)
	{
	    $this->data['Uuids'] = $uuids;
		foreach ($uuids as $i => $iValue) {
			$this->options['query']['Uuids.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getActionType()
 * @method $this withActionType($value)
 * @method string getNewFilePath()
 * @method $this withNewFilePath($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getPlatform()
 * @method $this withPlatform($value)
 * @method string getRegistryKey()
 * @method $this withRegistryKey($value)
 * @method string getCmdline()
 * @method $this withCmdline($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFilePath()
 * @method $this withFilePath($value)
 * @method string getMd5List()
 * @method $this withMd5List($value)
 * @method string getParentProcPath()
 * @method $this withParentProcPath($value)
 * @method string getId()
 * @method $this withId($value)
 * @method string getProcPath()
 * @method $this withProcPath($value)
 * @method string getParentCmdline()
 * @method $this withParentCmdline($value)
 * @method string getIP()
 * @method $this withIP($value)
 * @method string getRegistryContent()
 * @method $this withRegistryContent($value)
 * @method string getPortStr()
 * @method $this withPortStr($value)
 * @method string getPort()
 * @method $this withPort($value)
 * @method string getName()
 * @method $this withName($value)
 */
class ModifyClientUserDefineRule extends Rpc
{
}

/**
 * @method array getClusterIds()
 * @method string getUserConfirm()
 * @method $this withUserConfirm($value)
 */
class ModifyClusterCnnfStatusUserConfirm extends Rpc
{

    /**
     * @param array $clusterIds
     *
     * @return $this
     */
	public function withClusterIds(array $clusterIds)
	{
	    $this->data['ClusterIds'] = $clusterIds;
		foreach ($clusterIds as $i => $iValue) {
			$this->options['query']['ClusterIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 * @method string getConcernNecessity()
 * @method $this withConcernNecessity($value)
 */
class ModifyConcernNecessity extends Rpc
{
}

/**
 * @method string getReason()
 * @method $this withReason($value)
 * @method string getWhitelist()
 * @method $this withWhitelist($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getTargetInfo()
 * @method $this withTargetInfo($value)
 */
class ModifyCreateVulWhitelist extends Rpc
{
}

/**
 * @method string getExpireTime()
 * @method $this withExpireTime($value)
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getBound()
 * @method $this withBound($value)
 * @method string getBlockIp()
 * @method $this withBlockIp($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class ModifyCustomBlockRecord extends Rpc
{
}

/**
 * @method string getFirstDateStr()
 * @method $this withFirstDateStr($value)
 * @method string getTaskName()
 * @method $this withTaskName($value)
 * @method string getTargetStartTime()
 * @method $this withTargetStartTime($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getIntervalPeriod()
 * @method $this withIntervalPeriod($value)
 * @method string getParam()
 * @method $this withParam($value)
 * @method string getEnable()
 * @method $this withEnable($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 * @method string getTaskType()
 * @method $this withTaskType($value)
 * @method string getTargetEndTime()
 * @method $this withTargetEndTime($value)
 * @method string getPeriodUnit()
 * @method $this withPeriodUnit($value)
 * @method string getConfigId()
 * @method $this withConfigId($value)
 */
class ModifyCycleTask extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getUserAgreement()
 * @method $this withUserAgreement($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class ModifyEmgVulSubmit extends Rpc
{
}

/**
 * @method string getData()
 * @method $this withData($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class ModifyGroupProperty extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getNewRuleId()
 * @method $this withNewRuleId($value)
 */
class ModifyInstanceAntiBruteForceRule extends Rpc
{
}

/**
 * @method string getRuleName()
 * @method $this withRuleName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getOrderIndex()
 * @method $this withOrderIndex($value)
 * @method string getDstTarget()
 * @method $this withDstTarget($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getInterceptType()
 * @method $this withInterceptType($value)
 * @method string getRuleSwitch()
 * @method $this withRuleSwitch($value)
 * @method string getRuleId()
 * @method $this withRuleId($value)
 * @method string getSrcTarget()
 * @method $this withSrcTarget($value)
 */
class ModifyInterceptionRule extends Rpc
{
}

/**
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getRuleIds()
 * @method $this withRuleIds($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getRuleSwitch()
 * @method $this withRuleSwitch($value)
 */
class ModifyInterceptionRuleSwitch extends Rpc
{
}

/**
 * @method string getTargetId()
 * @method $this withTargetId($value)
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method array getImageList()
 * @method array getTagList()
 * @method string getTargetName()
 * @method $this withTargetName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getAppName()
 * @method $this withAppName($value)
 * @method string getNamespace()
 * @method $this withNamespace($value)
 */
class ModifyInterceptionTarget extends Rpc
{

    /**
     * @param array $imageList
     *
     * @return $this
     */
	public function withImageList(array $imageList)
	{
	    $this->data['ImageList'] = $imageList;
		foreach ($imageList as $i => $iValue) {
			$this->options['query']['ImageList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $tagList
     *
     * @return $this
     */
	public function withTagList(array $tagList)
	{
	    $this->data['TagList'] = $tagList;
		foreach ($tagList as $i => $iValue) {
			$this->options['query']['TagList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getConfigs()
 * @method $this withConfigs($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getTarget()
 * @method $this withTarget($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getConfig()
 * @method $this withConfig($value)
 */
class ModifyLoginBaseConfig extends Rpc
{
}

/**
 * @method string getItem()
 * @method $this withItem($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class ModifyLoginSwitchConfig extends Rpc
{
}

/**
 * @method string getProject()
 * @method $this withProject($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getLogStore()
 * @method $this withLogStore($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class ModifyLogMetaStatus extends Rpc
{
}

/**
 * @method string getProject()
 * @method $this withProject($value)
 * @method string getTimeLimit()
 * @method $this withTimeLimit($value)
 * @method string getRoute()
 * @method $this withRoute($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFocusLevel()
 * @method $this withFocusLevel($value)
 * @method string getCustomThreshold()
 * @method $this withCustomThreshold($value)
 */
class ModifyNoticeConfig extends Rpc
{
}

/**
 * @method array getLogMetaList()
 * @method string getTtl()
 * @method $this withTtl($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getHotTtl()
 * @method $this withHotTtl($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getTargetRegionId()
 * @method $this withTargetRegionId($value)
 */
class ModifyOpenLogShipper extends Rpc
{

    /**
     * @param array $logMetaList
     *
     * @return $this
     */
	public function withLogMetaList(array $logMetaList)
	{
	    $this->data['LogMetaList'] = $logMetaList;
		foreach ($logMetaList as $depth1 => $depth1Value) {
			if(isset($depth1Value['HotTtl'])){
				$this->options['query']['LogMetaList.' . ($depth1 + 1) . '.HotTtl'] = $depth1Value['HotTtl'];
			}
			if(isset($depth1Value['Ttl'])){
				$this->options['query']['LogMetaList.' . ($depth1 + 1) . '.Ttl'] = $depth1Value['Ttl'];
			}
			if(isset($depth1Value['ConfigLogStore'])){
				$this->options['query']['LogMetaList.' . ($depth1 + 1) . '.ConfigLogStore'] = $depth1Value['ConfigLogStore'];
			}
			if(isset($depth1Value['Status'])){
				$this->options['query']['LogMetaList.' . ($depth1 + 1) . '.Status'] = $depth1Value['Status'];
			}
		}

		return $this;
    }
}

/**
 * @method string getReason()
 * @method $this withReason($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getOperateType()
 * @method $this withOperateType($value)
 * @method string getInfo()
 * @method $this withInfo($value)
 */
class ModifyOperateVul extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getScheduleTime()
 * @method $this withScheduleTime($value)
 */
class ModifyPropertyScheduleConfig extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getTasks()
 * @method $this withTasks($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class ModifyPushAllTask extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getItemId()
 * @method $this withItemId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getTaskId()
 * @method $this withTaskId($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class ModifyRiskCheckStatus extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method array getIds()
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getTaskId()
 * @method $this withTaskId($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class ModifyRiskSingleResultStatus extends Rpc
{

    /**
     * @param array $ids
     *
     * @return $this
     */
	public function withIds(array $ids)
	{
	    $this->data['Ids'] = $ids;
		foreach ($ids as $i => $iValue) {
			$this->options['query']['Ids.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getEndTime()
 * @method $this withEndTime($value)
 * @method string getStartTime()
 * @method $this withStartTime($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getDaysOfWeek()
 * @method $this withDaysOfWeek($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class ModifySecurityCheckScheduleConfig extends Rpc
{
}

/**
 * @method string getInsertMarkMissParam()
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getDeleteMarkMissParam()
 * @method string getFrom()
 * @method string getLang()
 */
class ModifySecurityEventMarkMissIndividually extends Rpc
{

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withInsertMarkMissParam($value)
    {
        $this->data['InsertMarkMissParam'] = $value;
        $this->options['form_params']['InsertMarkMissParam'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withDeleteMarkMissParam($value)
    {
        $this->data['DeleteMarkMissParam'] = $value;
        $this->options['form_params']['DeleteMarkMissParam'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withFrom($value)
    {
        $this->data['From'] = $value;
        $this->options['form_params']['From'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withLang($value)
    {
        $this->data['Lang'] = $value;
        $this->options['form_params']['Lang'] = $value;

        return $this;
    }
}

/**
 * @method string getTypes()
 * @method $this withTypes($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class ModifyStartVulScan extends Rpc
{
}

/**
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method string getCycleDays()
 * @method $this withCycleDays($value)
 * @method string getStartTime()
 * @method $this withStartTime($value)
 * @method string getRiskSubTypeName()
 * @method $this withRiskSubTypeName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getId()
 * @method $this withId($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 * @method string getRiskCustomParams()
 * @method $this withRiskCustomParams($value)
 * @method string getEndTime()
 * @method $this withEndTime($value)
 * @method string getCustomType()
 * @method $this withCustomType($value)
 * @method string getCycleStartTime()
 * @method $this withCycleStartTime($value)
 * @method string getName()
 * @method $this withName($value)
 */
class ModifyStrategy extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getTarget()
 * @method $this withTarget($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getConfig()
 * @method $this withConfig($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class ModifyStrategyTarget extends Rpc
{
}

/**
 * @method string getTagId()
 * @method $this withTagId($value)
 * @method string getMachineTypes()
 * @method $this withMachineTypes($value)
 * @method string getTagList()
 * @method $this withTagList($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuidList()
 * @method $this withUuidList($value)
 */
class ModifyTagWithUuid extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getPolicyStatus()
 * @method $this withPolicyStatus($value)
 * @method string getSpeedLimiter()
 * @method $this withSpeedLimiter($value)
 * @method string getIncPlan()
 * @method $this withIncPlan($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPolicyId()
 * @method $this withPolicyId($value)
 * @method string getAccountName()
 * @method $this withAccountName($value)
 * @method string getFullPlan()
 * @method $this withFullPlan($value)
 * @method string getRetention()
 * @method $this withRetention($value)
 * @method string getAccountPassword()
 * @method $this withAccountPassword($value)
 * @method string getPolicyName()
 * @method $this withPolicyName($value)
 */
class ModifyUniBackupPolicy extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getHoneyPotAction()
 * @method $this withHoneyPotAction($value)
 * @method string getVpcId()
 * @method $this withVpcId($value)
 */
class ModifyVpcHoneyPot extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getConfig()
 * @method $this withConfig($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class ModifyVulConfig extends Rpc
{
}

/**
 * @method string getTarget()
 * @method $this withTarget($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getConfig()
 * @method $this withConfig($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class ModifyVulTarget extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getConfig()
 * @method $this withConfig($value)
 */
class ModifyVulTargetConfig extends Rpc
{
}

/**
 * @method string getReason()
 * @method $this withReason($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getTargetInfo()
 * @method $this withTargetInfo($value)
 * @method string getId()
 * @method $this withId($value)
 */
class ModifyVulWhitelistTarget extends Rpc
{
}

/**
 * @method string getLocalBackupDir()
 * @method $this withLocalBackupDir($value)
 * @method string getExclusiveFile()
 * @method $this withExclusiveFile($value)
 * @method string getExclusiveFileType()
 * @method $this withExclusiveFileType($value)
 * @method string getDir()
 * @method $this withDir($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getMode()
 * @method $this withMode($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getInclusiveFile()
 * @method $this withInclusiveFile($value)
 * @method string getExclusiveDir()
 * @method $this withExclusiveDir($value)
 * @method string getInclusiveFileType()
 * @method $this withInclusiveFileType($value)
 * @method string getDefenceMode()
 * @method $this withDefenceMode($value)
 */
class ModifyWebLockCreateConfig extends Rpc
{
}

/**
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getId()
 * @method $this withId($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class ModifyWebLockDeleteConfig extends Rpc
{
}

/**
 * @method string getDealAll()
 * @method $this withDealAll($value)
 * @method array getProcessPath()
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getOperateInfo()
 * @method $this withOperateInfo($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class ModifyWebLockProcessStatus extends Rpc
{

    /**
     * @param array $processPath
     *
     * @return $this
     */
	public function withProcessPath(array $processPath)
	{
	    $this->data['ProcessPath'] = $processPath;
		foreach ($processPath as $i => $iValue) {
			$this->options['query']['ProcessPath.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getLocalBackupDir()
 * @method $this withLocalBackupDir($value)
 * @method string getExclusiveFile()
 * @method $this withExclusiveFile($value)
 * @method string getExclusiveFileType()
 * @method $this withExclusiveFileType($value)
 * @method string getDir()
 * @method $this withDir($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getMode()
 * @method $this withMode($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getExclusiveDir()
 * @method $this withExclusiveDir($value)
 * @method string getInclusiveFileType()
 * @method $this withInclusiveFileType($value)
 * @method string getDefenceMode()
 * @method $this withDefenceMode($value)
 */
class ModifyWebLockStart extends Rpc
{
}

/**
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class ModifyWebLockStatus extends Rpc
{
}

/**
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class ModifyWebLockUnbind extends Rpc
{
}

/**
 * @method string getLocalBackupDir()
 * @method $this withLocalBackupDir($value)
 * @method string getExclusiveFile()
 * @method $this withExclusiveFile($value)
 * @method string getExclusiveFileType()
 * @method $this withExclusiveFileType($value)
 * @method string getDir()
 * @method $this withDir($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getMode()
 * @method $this withMode($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getId()
 * @method $this withId($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getInclusiveFile()
 * @method $this withInclusiveFile($value)
 * @method string getExclusiveDir()
 * @method $this withExclusiveDir($value)
 * @method string getInclusiveFileType()
 * @method $this withInclusiveFileType($value)
 * @method string getDefenceMode()
 * @method $this withDefenceMode($value)
 */
class ModifyWebLockUpdateConfig extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getTarget()
 * @method $this withTarget($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getConfig()
 * @method $this withConfig($value)
 */
class ModifyWebPath extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getSwitchOn()
 * @method $this withSwitchOn($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class OpenSensitiveFileScan extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getInstanceIds()
 * @method $this withInstanceIds($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class OperateAgentClientInstall extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 * @method string getConfig()
 * @method $this withConfig($value)
 */
class OperateCommonOverallConfig extends Rpc
{
}

/**
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getTargetOperations()
 * @method $this withTargetOperations($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFieldValue()
 * @method $this withFieldValue($value)
 * @method string getFieldName()
 * @method $this withFieldName($value)
 */
class OperateCommonTargetConfig extends Rpc
{
}

/**
 * @method string getImageUuid()
 * @method $this withImageUuid($value)
 * @method string getBaselineItemKeyList()
 * @method $this withBaselineItemKeyList($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method array getScanRange()
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getOperation()
 * @method $this withOperation($value)
 */
class OperateImageBaselineWhitelist extends Rpc
{

    /**
     * @param array $scanRange
     *
     * @return $this
     */
	public function withScanRange(array $scanRange)
	{
	    $this->data['ScanRange'] = $scanRange;
		foreach ($scanRange as $i => $iValue) {
			$this->options['query']['ScanRange.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getOperateType()
 * @method $this withOperateType($value)
 * @method string getInfo()
 * @method $this withInfo($value)
 */
class OperateImageVul extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 * @method string getNoTargetAsOn()
 * @method $this withNoTargetAsOn($value)
 * @method string getConfig()
 * @method $this withConfig($value)
 */
class OperateSuspiciousOverallConfig extends Rpc
{
}

/**
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getTargetOperations()
 * @method $this withTargetOperations($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class OperateSuspiciousTargetConfig extends Rpc
{
}

/**
 * @method string getOperationRange()
 * @method $this withOperationRange($value)
 * @method string getOperationAll()
 * @method $this withOperationAll($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getOperationCode()
 * @method $this withOperationCode($value)
 */
class OperateVirusEvents extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method array getVulNames()
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getOperateType()
 * @method $this withOperateType($value)
 * @method array getUuids()
 */
class OperateVuls extends Rpc
{

    /**
     * @param array $vulNames
     *
     * @return $this
     */
	public function withVulNames(array $vulNames)
	{
	    $this->data['VulNames'] = $vulNames;
		foreach ($vulNames as $i => $iValue) {
			$this->options['query']['VulNames.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $uuids
     *
     * @return $this
     */
	public function withUuids(array $uuids)
	{
	    $this->data['Uuids'] = $uuids;
		foreach ($uuids as $i => $iValue) {
			$this->options['query']['Uuids.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getDealAll()
 * @method $this withDealAll($value)
 * @method array getEventIds()
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getOperationCode()
 * @method $this withOperationCode($value)
 */
class OperateWebLockFileEvents extends Rpc
{

    /**
     * @param array $eventIds
     *
     * @return $this
     */
	public function withEventIds(array $eventIds)
	{
	    $this->data['EventIds'] = $eventIds;
		foreach ($eventIds as $i => $iValue) {
			$this->options['query']['EventIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method array getSecurityEventIds()
 */
class OperationCancelIgnoreSuspEvent extends Rpc
{

    /**
     * @param array $securityEventIds
     *
     * @return $this
     */
	public function withSecurityEventIds(array $securityEventIds)
	{
	    $this->data['SecurityEventIds'] = $securityEventIds;
		foreach ($securityEventIds as $i => $iValue) {
			$this->options['query']['SecurityEventIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getSuspiciousEventIds()
 * @method $this withSuspiciousEventIds($value)
 * @method string getSubOperation()
 * @method $this withSubOperation($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getWarnType()
 * @method $this withWarnType($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getOperation()
 * @method $this withOperation($value)
 */
class OperationSuspEvents extends Rpc
{
}

/**
 * @method string getRegistryNameLike()
 * @method string getCurrentPage()
 * @method array getRegistryTypeNotInList()
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method array getRegistryTypeInList()
 */
class PageImageRegistry extends Rpc
{

    /** @var string */
    public $scheme = 'https';

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withRegistryNameLike($value)
    {
        $this->data['RegistryNameLike'] = $value;
        $this->options['form_params']['RegistryNameLike'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withCurrentPage($value)
    {
        $this->data['CurrentPage'] = $value;
        $this->options['form_params']['CurrentPage'] = $value;

        return $this;
    }

    /**
     * @param array $registryTypeNotInList
     *
     * @return $this
     */
	public function withRegistryTypeNotInList(array $registryTypeNotInList)
	{
	    $this->data['RegistryTypeNotInList'] = $registryTypeNotInList;
		foreach ($registryTypeNotInList as $i => $iValue) {
			$this->options['form_params']['RegistryTypeNotInList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withPageSize($value)
    {
        $this->data['PageSize'] = $value;
        $this->options['form_params']['PageSize'] = $value;

        return $this;
    }

    /**
     * @param array $registryTypeInList
     *
     * @return $this
     */
	public function withRegistryTypeInList(array $registryTypeInList)
	{
	    $this->data['RegistryTypeInList'] = $registryTypeInList;
		foreach ($registryTypeInList as $i => $iValue) {
			$this->options['form_params']['RegistryTypeInList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getAppName()
 * @method $this withAppName($value)
 * @method string getValue()
 * @method $this withValue($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class PauseClient extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getDigests()
 * @method $this withDigests($value)
 * @method string getRegistryTypes()
 * @method $this withRegistryTypes($value)
 * @method string getRegionIds()
 * @method $this withRegionIds($value)
 * @method string getTags()
 * @method $this withTags($value)
 * @method string getRepoNamespaces()
 * @method $this withRepoNamespaces($value)
 * @method string getInstanceIds()
 * @method $this withInstanceIds($value)
 * @method string getRepoIds()
 * @method $this withRepoIds($value)
 * @method string getRepoNames()
 * @method $this withRepoNames($value)
 */
class PublicCreateImageScanTask extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getDigests()
 * @method $this withDigests($value)
 * @method string getRegistryTypes()
 * @method $this withRegistryTypes($value)
 * @method string getRegionIds()
 * @method $this withRegionIds($value)
 * @method string getTags()
 * @method $this withTags($value)
 * @method string getRepoNamespaces()
 * @method $this withRepoNamespaces($value)
 * @method string getInstanceIds()
 * @method $this withInstanceIds($value)
 * @method string getRepoIds()
 * @method $this withRepoIds($value)
 * @method string getRepoNames()
 * @method $this withRepoNames($value)
 */
class PublicPreCheckImageScanTask extends Rpc
{
}

/**
 * @method string getImages()
 * @method $this withImages($value)
 * @method string getImageItems()
 * @method $this withImageItems($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class PublicSyncAndCreateImageScanTask extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getCreateMark()
 * @method $this withCreateMark($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class QueryDiscoverDatabase extends Rpc
{
}

/**
 * @method string getRemark()
 * @method string getEventName()
 * @method string getDisposalWay()
 * @method $this withDisposalWay($value)
 * @method string getMaxId()
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method string getFrom()
 * @method string getLang()
 * @method string getCurrentPage()
 */
class QueryGroupedSecurityEventMarkMissList extends Rpc
{

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withRemark($value)
    {
        $this->data['Remark'] = $value;
        $this->options['form_params']['Remark'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withEventName($value)
    {
        $this->data['EventName'] = $value;
        $this->options['form_params']['EventName'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withMaxId($value)
    {
        $this->data['MaxId'] = $value;
        $this->options['form_params']['MaxId'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withPageSize($value)
    {
        $this->data['PageSize'] = $value;
        $this->options['form_params']['PageSize'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withFrom($value)
    {
        $this->data['From'] = $value;
        $this->options['form_params']['From'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withLang($value)
    {
        $this->data['Lang'] = $value;
        $this->options['form_params']['Lang'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withCurrentPage($value)
    {
        $this->data['CurrentPage'] = $value;
        $this->options['form_params']['CurrentPage'] = $value;

        return $this;
    }
}

/**
 * @method string getGroupName()
 * @method $this withGroupName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class QueryGroupIdByGroupName extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class QueryJenkinsImageRegistryPersistenceDay extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getInstanceUuid()
 * @method $this withInstanceUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getTaskId()
 * @method $this withTaskId($value)
 * @method string getUniRegionId()
 * @method $this withUniRegionId($value)
 */
class QueryPreCheckDatabase extends Rpc
{
}

/**
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class RebootMachine extends Rpc
{
}

/**
 * @method string getCloudAssetType()
 * @method $this withCloudAssetType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getCloudAssetSubType()
 * @method $this withCloudAssetSubType($value)
 * @method string getAssetType()
 * @method $this withAssetType($value)
 */
class RefreshAssets extends Rpc
{
}

/**
 * @method string getRefreshImmediately()
 * @method $this withRefreshImmediately($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getAssetType()
 * @method $this withAssetType($value)
 */
class RefreshContainerAssets extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method array getInstanceIds()
 * @method string getCheckId()
 * @method $this withCheckId($value)
 */
class RemoveCheckInstanceResultWhiteList extends Rpc
{

    /**
     * @param array $instanceIds
     *
     * @return $this
     */
	public function withInstanceIds(array $instanceIds)
	{
	    $this->data['InstanceIds'] = $instanceIds;
		foreach ($instanceIds as $i => $iValue) {
			$this->options['query']['InstanceIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method array getCheckIds()
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getCheckGroupId()
 * @method $this withCheckGroupId($value)
 */
class RemoveCheckResultWhiteList extends Rpc
{

    /**
     * @param array $checkIds
     *
     * @return $this
     */
	public function withCheckIds(array $checkIds)
	{
	    $this->data['CheckIds'] = $checkIds;
		foreach ($checkIds as $i => $iValue) {
			$this->options['query']['CheckIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getQuaraFileId()
 * @method $this withQuaraFileId($value)
 */
class RollbackSuspEventQuaraFile extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class SasInstallCode extends Rpc
{
}

/**
 * @method string getBaselineItemList()
 * @method $this withBaselineItemList($value)
 * @method string getStrategyName()
 * @method $this withStrategyName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getStrategyId()
 * @method $this withStrategyId($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class SaveImageBaselineStrategy extends Rpc
{
}

/**
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getLevelsOn()
 * @method $this withLevelsOn($value)
 */
class SaveSuspEventUserSetting extends Rpc
{
}

/**
 * @method string getClusterIds()
 * @method $this withClusterIds($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getSwitchType()
 * @method $this withSwitchType($value)
 * @method string getSwitchOn()
 * @method $this withSwitchOn($value)
 */
class SetClusterInterceptionConfig extends Rpc
{
}

/**
 * @method string getScanDayNum()
 * @method $this withScanDayNum($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class SetRegistryScanDayNum extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method array getItemIds()
 * @method string getType()
 * @method $this withType($value)
 * @method array getAssets()
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class StartBaselineSecurityCheck extends Rpc
{

    /**
     * @param array $itemIds
     *
     * @return $this
     */
	public function withItemIds(array $itemIds)
	{
	    $this->data['ItemIds'] = $itemIds;
		foreach ($itemIds as $i => $iValue) {
			$this->options['query']['ItemIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $assets
     *
     * @return $this
     */
	public function withAssets(array $assets)
	{
	    $this->data['Assets'] = $assets;
		foreach ($assets as $i => $iValue) {
			$this->options['query']['Assets.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class StartDiscoverDatabaseTask extends Rpc
{
}

/**
 * @method string getDatabaseType()
 * @method $this withDatabaseType($value)
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getInstanceUuid()
 * @method $this withInstanceUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUniRegionId()
 * @method $this withUniRegionId($value)
 */
class StartPreCheckDatabase extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getTargetInfo()
 * @method $this withTargetInfo($value)
 */
class StartVirusScanTask extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class SubmitCheck extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class UnbindAegis extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method array getUuidList()
 * @method string getPolicyVersion()
 * @method $this withPolicyVersion($value)
 */
class UninstallBackupClient extends Rpc
{

    /**
     * @param array $uuidList
     *
     * @return $this
     */
	public function withUuidList(array $uuidList)
	{
	    $this->data['UuidList'] = $uuidList;
		foreach ($uuidList as $i => $iValue) {
			$this->options['query']['UuidList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPolicyId()
 * @method $this withPolicyId($value)
 */
class UninstallUniBackupAgent extends Rpc
{
}

/**
 * @method string getHoneypotName()
 * @method $this withHoneypotName($value)
 * @method string getHoneypotId()
 * @method $this withHoneypotId($value)
 * @method string getMeta()
 * @method $this withMeta($value)
 */
class UpdateHoneypot extends Rpc
{
}

/**
 * @method string getAvailableProbeNum()
 * @method $this withAvailableProbeNum($value)
 * @method string getNodeId()
 * @method $this withNodeId($value)
 * @method string getNodeName()
 * @method $this withNodeName($value)
 * @method array getSecurityGroupProbeIpList()
 */
class UpdateHoneypotNode extends Rpc
{

    /**
     * @param array $securityGroupProbeIpList
     *
     * @return $this
     */
	public function withSecurityGroupProbeIpList(array $securityGroupProbeIpList)
	{
	    $this->data['SecurityGroupProbeIpList'] = $securityGroupProbeIpList;
		foreach ($securityGroupProbeIpList as $i => $iValue) {
			$this->options['query']['SecurityGroupProbeIpList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getHoneypotPresetId()
 * @method $this withHoneypotPresetId($value)
 * @method string getPresetName()
 * @method $this withPresetName($value)
 * @method string getMeta()
 * @method $this withMeta($value)
 * @method string getHoneypotImageName()
 * @method $this withHoneypotImageName($value)
 */
class UpdateHoneypotPreset extends Rpc
{
}

/**
 * @method string getPing()
 * @method $this withPing($value)
 * @method string getProbeId()
 * @method $this withProbeId($value)
 * @method array getServiceIpList()
 * @method string getArp()
 * @method $this withArp($value)
 * @method string getDisplayName()
 * @method $this withDisplayName($value)
 */
class UpdateHoneypotProbe extends Rpc
{

    /**
     * @param array $serviceIpList
     *
     * @return $this
     */
	public function withServiceIpList(array $serviceIpList)
	{
	    $this->data['ServiceIpList'] = $serviceIpList;
		foreach ($serviceIpList as $i => $iValue) {
			$this->options['query']['ServiceIpList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getRegistryId()
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getRegistryName()
 */
class UpdateJenkinsImageRegistryName extends Rpc
{

    /** @var string */
    public $scheme = 'https';

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withRegistryId($value)
    {
        $this->data['RegistryId'] = $value;
        $this->options['form_params']['RegistryId'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withRegistryName($value)
    {
        $this->data['RegistryName'] = $value;
        $this->options['form_params']['RegistryName'] = $value;

        return $this;
    }
}

/**
 * @method string getRegistryId()
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPersistenceDay()
 */
class UpdateJenkinsImageRegistryPersistenceDay extends Rpc
{

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withRegistryId($value)
    {
        $this->data['RegistryId'] = $value;
        $this->options['form_params']['RegistryId'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withPersistenceDay($value)
    {
        $this->data['PersistenceDay'] = $value;
        $this->options['form_params']['PersistenceDay'] = $value;

        return $this;
    }
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getId()
 * @method $this withId($value)
 */
class UpgradeBackupPolicyVersion extends Rpc
{
}

/**
 * @method string getRiskIds()
 * @method $this withRiskIds($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class ValidateHcWarnings extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method array getInstanceIds()
 * @method string getCheckId()
 * @method $this withCheckId($value)
 */
class VerifyCheckInstanceResult extends Rpc
{

    /**
     * @param array $instanceIds
     *
     * @return $this
     */
	public function withInstanceIds(array $instanceIds)
	{
	    $this->data['InstanceIds'] = $instanceIds;
		foreach ($instanceIds as $i => $iValue) {
			$this->options['query']['InstanceIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method array getCheckIds()
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class VerifyCheckResult extends Rpc
{

    /**
     * @param array $checkIds
     *
     * @return $this
     */
	public function withCheckIds(array $checkIds)
	{
	    $this->data['CheckIds'] = $checkIds;
		foreach ($checkIds as $i => $iValue) {
			$this->options['query']['CheckIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}
