<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @method static where(string $string, string $uid)
 * @method static create(array $array)
 * @method static insert(array $template_data)
 * @method whereIn(string $string, array $ids)
 * @method static offset(mixed $start)
 * @method static count()
 * @method static whereLike(string[] $array, mixed $search)
 */
class Templates extends Model
{

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
            'name',
            'user_id',
            'message',
            'status',
            'sender_id',
            'dlt_template_id',
            'dlt_category',
            'approved',
    ];


    /**
     *
     * @var string[]
     */
    protected $casts = [
            'status'   => 'boolean',
    ];

    /**
     * Bootstrap any application services.
     */
    public static function boot()
    {
        parent::boot();

        // Create uid when creating list.
        static::creating(function ($item) {
            // Create new uid
            $uid = uniqid();
            while (self::where('uid', $uid)->count() > 0) {
                $uid = uniqid();
            }
            $item->uid = $uid;

        });
    }

    /**
     * get user
     *
     * @return BelongsTo
     *
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * get sender id
     *
     * @return BelongsTo
     *
     */
    public function senderid(): BelongsTo
    {
        return $this->belongsTo(Senderid::class);
    }


    /**
     * get route key by uid
     *
     * @return string
     */
    public function getRouteKeyName(): string
    {
        return 'uid';
    }

    /**
     * @return string
     */
    public function __toString(): string
    {
        return $this->name;
    }
}
