<?php


namespace App\Http\Controllers\API;


use App\Library\Tool;
use App\Models\Traits\ApiResponser;
use App\Models\User;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class APIHTTPController
{
    use ApiResponser;

    /**
     * get profile
     *
     * @param  Request  $request
     *
     * @return JsonResponse
     */

    public function me(Request $request): JsonResponse
    {

        if (config('app.stage') == 'demo') {
            return response()->json([
                    'status'  => 'error',
                    'message' => 'Sorry! This option is not available in demo mode',
            ]);
        }

        $user = User::where('api_token', $request->api_token)->first();
        if ( ! $user) {
            return response()->json([
                    'status'  => 'error',
                    'message' => __('locale.auth.failed'),
            ]);
        }

        $data = [
                'uid'            => $user->uid,
                'api_token'      => $user->api_token,
                'first_name'     => $user->first_name,
                'last_name'      => $user->last_name,
                'email'          => $user->email,
                "locale"         => $user->locale,
                "timezone"       => $user->timezone,
                "last_access_at" => Tool::customerDateTime($user->last_access_at),
        ];

        return $this->success($data);
    }

    /**
     * get balance information
     *
     * @param  Request  $request
     *
     * @return JsonResponse
     */
    public function balance(Request $request): JsonResponse
    {

        if (config('app.stage') == 'demo') {
            return response()->json([
                    'status'  => 'error',
                    'message' => 'Sorry! This option is not available in demo mode',
            ]);
        }

        $user = User::where('api_token', $request->api_token)->first();
        if ( ! $user) {
            return response()->json([
                    'status'  => 'error',
                    'message' => __('locale.auth.failed'),
            ]);
        }

        $data = [
                'remaining_unit' => ($user->sms_unit == -1) ? __('locale.labels.unlimited') : Tool::format_number($user->sms_unit),
                'expired_on'     => Tool::customerDateTime($user->customer->subscription->current_period_ends_at),
        ];

        return $this->success($data);

    }

}
